/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.player.IPlayerConditionModule;
import com.gildedgames.aether.api.player.conditions.IConditionResolution;
import com.gildedgames.aether.api.travellers_guidebook.ITGEntry;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketFlagPlayerCondition;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerConditionModule
extends PlayerAetherModule
implements IPlayerConditionModule {
    private HashSet<ResourceLocation> conditionsMet = Sets.newHashSet();
    private final Function<ResourceLocation, Boolean> isConditionMet = this::isConditionFlagged;

    public PlayerConditionModule(PlayerAether playerAether) {
        super(playerAether);
    }

    @Override
    public void flagCondition(ResourceLocation conditionUniqueIdentifier) {
        this.conditionsMet.add(conditionUniqueIdentifier);
        if (!this.getWorld().field_72995_K) {
            NetworkingAether.sendPacketToPlayer(new PacketFlagPlayerCondition(conditionUniqueIdentifier), (EntityPlayerMP)this.getEntity());
        }
    }

    @Override
    public boolean isConditionFlagged(ResourceLocation conditionUniqueIdentifier) {
        return this.conditionsMet.contains(conditionUniqueIdentifier);
    }

    @Override
    public boolean areConditionsFlagged(IConditionResolution conditionResolution, ResourceLocation ... conditionUniqueIdentifiers) {
        return conditionResolution.areConditionsMet(conditionUniqueIdentifiers, this.isConditionMet);
    }

    @Override
    public boolean isEntryUnlocked(ITGEntry entry) {
        return this.areConditionsFlagged(entry.getConditionResolution(), entry.getConditionIDs().toArray(new ResourceLocation[0]));
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
    }

    @Override
    public void tickEnd(TickEvent.PlayerTickEvent event) {
    }

    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setSet("conditionsMet", this.conditionsMet, NBTFunnel.RESOURCE_SETTER);
    }

    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.conditionsMet = Sets.newHashSet((Iterable)funnel.getSet("conditionsMet", NBTFunnel.RESOURCE_GETTER));
    }
}

