/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.registrar.BiomesAether;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.entities.monsters.EntityCockatrice;
import com.gildedgames.aether.common.entities.monsters.EntitySwet;
import com.gildedgames.aether.common.entities.monsters.EntityTempest;
import com.gildedgames.aether.common.entities.monsters.EntityVaranys;
import com.gildedgames.aether.common.util.helpers.AetherHelper;
import com.gildedgames.aether.common.world.spawning.SpawnHandler;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerCaveSpawnModule
extends PlayerAetherModule {
    private int playerYPos = 0;
    private Biome currentPlayerBiome = null;
    private ArrayList<Class<? extends EntityCreature>> spawnableMobs = new ArrayList();
    private boolean hasSpawned = true;
    private int timer = this.timerMax;
    private final int timerMax = 100;
    private final int maximumYPos = 70;
    private final int minimumYPos = 10;
    private final int maxLightLevel = 8;

    public PlayerCaveSpawnModule(PlayerAether playerAether) {
        super(playerAether);
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
        if (!AetherHelper.isAether(this.getWorld()) || this.getWorld().field_72995_K) {
            return;
        }
        if (this.currentPlayerBiome != this.getWorld().func_180494_b(this.getEntity().func_180425_c())) {
            this.currentPlayerBiome = this.getWorld().func_180494_b(this.getEntity().func_180425_c());
            this.updateEntityList(this.currentPlayerBiome, this.getWorld());
        }
        this.playerYPos = MathHelper.func_76128_c((double)this.getPlayer().getEntity().field_70163_u);
        if (this.playerYPos < this.minimumYPos) {
            this.playerYPos = this.minimumYPos;
        }
    }

    @Override
    public void tickEnd(TickEvent.PlayerTickEvent event) {
        if (this.getEntity().field_70170_p.field_72995_K || !AetherHelper.isAether(this.getWorld())) {
            return;
        }
        int yTranslation = this.playerYPos / 10;
        if (yTranslation <= 0) {
            yTranslation = 1;
        }
        if (!this.spawnableMobs.isEmpty() && this.playerYPos < this.maximumYPos && !this.hasSpawned) {
            int mobInList = this.getWorld().field_73012_v.nextInt(this.spawnableMobs.size());
            int numberOfMobs = this.getWorld().field_73012_v.nextInt(2);
            block0: for (int i = 0; i < numberOfMobs && this.getWorld().field_73012_v.nextInt(yTranslation) == 0; ++i) {
                EntityCreature mobToSpawn = (EntityCreature)EntityList.func_191304_a(this.spawnableMobs.get(mobInList), (World)this.getWorld());
                double distanceToSpawn = 16.0;
                int yController = 16;
                if (mobToSpawn instanceof EntityTempest && this.playerYPos < 25) {
                    yController = 8;
                    distanceToSpawn = 8.0;
                }
                EntityLiving.SpawnPlacementType placementType = EntityLiving.SpawnPlacementType.ON_GROUND;
                for (int j = 0; j < 100; ++j) {
                    BlockPos spawnPos = this.getPosToSpawn(MathHelper.func_76128_c((double)this.getEntity().field_70165_t) >> 4, MathHelper.func_76128_c((double)this.getEntity().field_70161_v) >> 4, yController, this.getWorld().field_73012_v);
                    mobToSpawn.func_70107_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
                    if (SpawnHandler.isNotColliding(placementType, this.getWorld(), (Entity)mobToSpawn) || this.getWorld().func_175636_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), distanceToSpawn) || !this.isGroundBelowPosition(spawnPos, mobToSpawn) || this.getWorld().func_184143_b(mobToSpawn.func_174813_aQ()) || this.getWorld().func_175699_k(spawnPos) > this.maxLightLevel) continue;
                    mobToSpawn.field_70759_as = mobToSpawn.field_70177_z;
                    mobToSpawn.field_70761_aq = mobToSpawn.field_70177_z;
                    this.getWorld().func_72838_d((Entity)mobToSpawn);
                    AetherCore.LOGGER.info("PlayerCaveSpawnModule spawned " + mobToSpawn.toString());
                    continue block0;
                }
            }
            this.hasSpawned = true;
        }
        --this.timer;
        if (this.timer <= 0) {
            this.timer = this.timerMax * yTranslation;
            this.hasSpawned = false;
        }
    }

    private void updateEntityList(Biome biome, World world) {
        this.spawnableMobs.clear();
        this.spawnableMobs.add(EntityCockatrice.class);
        this.spawnableMobs.add(EntityTempest.class);
        this.spawnableMobs.add(EntitySwet.class);
        if (biome == BiomesAether.HIGHLANDS) {
            // empty if block
        }
        if (biome == BiomesAether.ARCTIC_PEAKS) {
            this.spawnableMobs.add(EntityVaranys.class);
        }
        if (biome == BiomesAether.MAGNETIC_HILLS) {
            // empty if block
        }
        if (biome == BiomesAether.FORGOTTEN_HIGHLANDS) {
            // empty if block
        }
        if (biome == BiomesAether.IRRADIATED_FORESTS) {
            // empty if block
        }
    }

    private BlockPos getPosToSpawn(int chunkX, int chunkZ, int yDistance, Random rand) {
        int x = rand.nextInt(16) + chunkX * 16;
        int y = rand.nextInt(yDistance);
        int z = rand.nextInt(16) + chunkZ * 16;
        if (rand.nextBoolean()) {
            y *= -1;
        }
        return new BlockPos(x, y += MathHelper.func_76128_c((double)this.getEntity().field_70163_u), z);
    }

    private boolean isGroundBelowPosition(BlockPos position, EntityCreature entity) {
        if (entity instanceof EntityTempest) {
            return true;
        }
        for (int i = 0; i < 8; ++i) {
            if (this.getWorld().func_175623_d(position.func_177979_c(i))) continue;
            return true;
        }
        return false;
    }
}

