/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.player.IPlayerAetherModule;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.BlockPosDimension;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class PlayerCampfiresModule
extends PlayerAetherModule
implements IPlayerAetherModule.Serializable {
    public Set<BlockPosDimension> campfiresActivated = Sets.newHashSet();
    private boolean shouldRespawnAtCampfire;
    private BlockPosDimension deathPos;

    public PlayerCampfiresModule(PlayerAether playerAether) {
        super(playerAether);
    }

    public BlockPosDimension getDeathPos() {
        return this.deathPos;
    }

    public void setDeathPos(BlockPosDimension deathPos) {
        this.deathPos = deathPos;
    }

    public boolean hasCampfire(BlockPosDimension campfire) {
        return this.campfiresActivated.contains(campfire);
    }

    public Set<BlockPosDimension> getCampfiresActivated() {
        return this.campfiresActivated;
    }

    public void setCampfiresActivated(Set<BlockPosDimension> campfiresActivated) {
        this.campfiresActivated = campfiresActivated;
    }

    public BlockPos getClosestCampfire() {
        BlockPos closest = null;
        int x = this.getDeathPos().func_177958_n();
        int y = this.getDeathPos().func_177956_o();
        int z = this.getDeathPos().func_177952_p();
        for (BlockPos blockPos : this.campfiresActivated) {
            if (closest == null) {
                closest = blockPos;
                continue;
            }
            if (!(closest.func_185332_f(x, y, z) > blockPos.func_185332_f(x, y, z))) continue;
            closest = blockPos;
        }
        return closest;
    }

    public void addActivatedCampfire(BlockPosDimension campfire) {
        this.campfiresActivated.add(campfire);
    }

    public void setShouldRespawnAtCampfire(boolean flag) {
        this.shouldRespawnAtCampfire = flag;
    }

    public boolean shouldRespawnAtCampfire() {
        return this.shouldRespawnAtCampfire;
    }

    public void write(NBTTagCompound compound) {
        NBTFunnel funnel = new NBTFunnel(compound);
        funnel.setSet("campfiresActivated", this.campfiresActivated);
        funnel.set("deathPos", (NBT)this.deathPos);
        compound.func_74757_a("shouldRespawnAtCampfire", this.shouldRespawnAtCampfire);
    }

    public void read(NBTTagCompound compound) {
        NBTFunnel funnel = new NBTFunnel(compound);
        this.campfiresActivated = funnel.getSet("campfiresActivated");
        this.deathPos = (BlockPosDimension)funnel.get("deathPos");
        this.shouldRespawnAtCampfire = compound.func_74767_n("shouldRespawnAtCampfire");
    }

    @Override
    public ResourceLocation getIdentifier() {
        return AetherCore.getResource("campfires");
    }
}

