/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.entities.blocks.EntityMovingBlock;
import com.gildedgames.aether.common.init.MaterialsAether;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerBlockLevitateModule
extends PlayerAetherModule {
    private EntityMovingBlock heldBlock;

    public PlayerBlockLevitateModule(PlayerAether playerAether) {
        super(playerAether);
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
        if (this.getEntity().field_70170_p.field_72995_K || this.getEntity().field_70128_L) {
            return;
        }
        if (this.heldBlock != null) {
            if (this.heldBlock.field_70128_L || this.heldBlock.isFalling()) {
                this.heldBlock = null;
            } else {
                ItemStack stack = this.getEntity().func_184582_a(EntityEquipmentSlot.MAINHAND);
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemTool && Objects.equals(((ItemTool)stack.func_77973_b()).func_77861_e(), MaterialsAether.GRAVITITE_TOOL.name())) {
                    if (this.heldBlock.field_70173_aa % 20 == 0) {
                        int extra = (int)Math.floor(Math.min(6, this.heldBlock.field_70173_aa / 60));
                        stack.func_77972_a(2 + extra, (EntityLivingBase)this.getEntity());
                    }
                } else {
                    this.dropHeldBlock();
                }
            }
        }
    }

    @Override
    public void onDeath(LivingDeathEvent event) {
        this.dropHeldBlock();
    }

    public boolean pickupBlock(BlockPos pos, World world) {
        if (this.heldBlock == null && world.func_175660_a(this.getEntity(), pos)) {
            IBlockState state = world.func_180495_p(pos);
            EntityMovingBlock movingBlock = new EntityMovingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, state);
            world.func_72838_d((Entity)movingBlock);
            this.holdBlock(movingBlock);
            return true;
        }
        return false;
    }

    private void holdBlock(EntityMovingBlock entity) {
        this.dropHeldBlock();
        this.heldBlock = entity;
        this.heldBlock.setHoldingPlayer(this.getEntity());
    }

    public EntityMovingBlock getHeldBlock() {
        return this.heldBlock;
    }

    public void dropHeldBlock() {
        if (this.getHeldBlock() != null) {
            this.getHeldBlock().setHoldingPlayer(null);
        }
    }
}

