/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.player.IPlayerAetherModule;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerAbilitiesModule
extends PlayerAetherModule
implements IPlayerAetherModule.Serializable {
    private int jumpsSoFar;
    private int midAirJumpsAllowed;
    private int ticksAirborne;

    public PlayerAbilitiesModule(PlayerAether playerAether) {
        super(playerAether);
    }

    public int getMidAirJumpsAllowed() {
        return this.midAirJumpsAllowed;
    }

    public void setMidAirJumpsAllowed(int midAirJumpsAllowed) {
        this.midAirJumpsAllowed = midAirJumpsAllowed;
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
        if (this.getEntity().field_70122_E) {
            this.jumpsSoFar = 0;
            this.ticksAirborne = 0;
        } else {
            ++this.ticksAirborne;
        }
    }

    public void onFall(LivingFallEvent event) {
        if (this.getMidAirJumpsAllowed() > 0) {
            event.setResult(Event.Result.DENY);
        }
    }

    public int getTicksAirborne() {
        return this.ticksAirborne;
    }

    public boolean performMidAirJump() {
        if (this.jumpsSoFar < this.midAirJumpsAllowed && this.ticksAirborne > 2) {
            AetherCore.PROXY.spawnJumpParticles(this.getEntity().field_70170_p, this.getEntity().field_70165_t, this.getEntity().field_70163_u, this.getEntity().field_70161_v, 1.5, 12);
            this.getEntity().field_70181_x = 0.55;
            this.getEntity().field_70143_R = -4.0f;
            this.getEntity().field_70159_w *= 1.4;
            this.getEntity().field_70179_y *= 1.4;
            ++this.jumpsSoFar;
            return true;
        }
        return false;
    }

    public void write(NBTTagCompound tag) {
        NBTTagCompound root = new NBTTagCompound();
        tag.func_74782_a("Abilities", (NBTBase)root);
        tag.func_74768_a("midAirJumpsAllowed", this.midAirJumpsAllowed);
        tag.func_74768_a("jumpsSoFar", this.jumpsSoFar);
    }

    public void read(NBTTagCompound tag) {
        NBTTagCompound root = tag.func_74775_l("Abilities");
        this.midAirJumpsAllowed = root.func_74762_e("midAirJumpsAllowed");
        this.jumpsSoFar = root.func_74762_e("jumpsSoFar");
    }

    @Override
    public ResourceLocation getIdentifier() {
        return AetherCore.getResource("abilities");
    }
}

