/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player;

import com.gildedgames.aether.api.player.IPlayerAether;
import com.gildedgames.aether.api.player.IPlayerAetherModule;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerAbilitiesModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerBlockLevitateModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerCampfiresModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerCaveSpawnModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerConditionModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerConfigModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerCurrencyModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerDialogModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerEquipmentModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerParachuteModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerPatronRewardModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerPreventDropsModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerProgressModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerRollMovementModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerSectorModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerSpecialEquipmentModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerSwetTrackerModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerTeleportingModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerTradeModule;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketCampfires;
import com.gildedgames.aether.common.network.packets.PacketCurrencyModule;
import com.gildedgames.aether.common.network.packets.PacketEquipment;
import com.gildedgames.aether.common.network.packets.PacketPlayerConditionModule;
import com.gildedgames.aether.common.network.packets.PacketPreventDropsInventories;
import com.gildedgames.aether.common.network.packets.PacketProgressModule;
import com.gildedgames.aether.common.network.packets.PacketSetPlayedIntro;
import com.gildedgames.aether.common.world.instances.necromancer_tower.NecromancerTowerInstance;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerAether
implements IPlayerAether {
    private final EntityPlayer entity;
    private final IdentityHashMap<Class<? extends IPlayerAetherModule>, IPlayerAetherModule> modulesKeyed = new IdentityHashMap();
    private final List<IPlayerAetherModule> modules = new ArrayList<IPlayerAetherModule>();
    private final List<IPlayerAetherModule.Serializable> modulesSerializable = new ArrayList<IPlayerAetherModule.Serializable>();
    private NecromancerTowerInstance towerInstance;
    private ItemStack lastDestroyedStack;
    private int ticksWithEggnogEffect;
    private boolean isTrading;
    private boolean isJumping = false;
    private float cooldownTracker = 0.0f;

    public PlayerAether() {
        this.entity = null;
    }

    public PlayerAether(EntityPlayer entity) {
        this.entity = entity;
        this.registerModule(new PlayerAbilitiesModule(this));
        this.registerModule(new PlayerBlockLevitateModule(this));
        this.registerModule(new PlayerTeleportingModule(this));
        this.registerModule(new PlayerParachuteModule(this));
        this.registerModule(new PlayerEquipmentModule(this));
        this.registerModule(new PlayerDialogModule(this));
        this.registerModule(new PlayerSwetTrackerModule(this));
        this.registerModule(new PlayerCampfiresModule(this));
        this.registerModule(new PlayerPreventDropsModule(this));
        this.registerModule(new PlayerPatronRewardModule(this));
        this.registerModule(new PlayerRollMovementModule(this));
        this.registerModule(new PlayerConfigModule(this));
        this.registerModule(new PlayerProgressModule(this));
        this.registerModule(new PlayerCurrencyModule(this));
        this.registerModule(new PlayerSectorModule(this));
        this.registerModule(new PlayerTradeModule(this));
        this.registerModule(new PlayerCaveSpawnModule(this));
        this.registerModule(new PlayerConditionModule(this));
        this.registerModule(new PlayerSpecialEquipmentModule(this));
    }

    @Nonnull
    public static PlayerAether getPlayer(EntityPlayer player) {
        if (player == null) {
            throw new NullPointerException("Player entity is null");
        }
        PlayerAether ret = (PlayerAether)player.getCapability(CapabilitiesAether.PLAYER_DATA, null);
        if (ret == null) {
            throw new NullPointerException("Player does not contain capability");
        }
        return ret;
    }

    public static boolean hasCapability(Entity entity) {
        return entity.hasCapability(CapabilitiesAether.PLAYER_DATA, null);
    }

    @Override
    public void registerModule(IPlayerAetherModule module) {
        Class<?> clazz = module.getClass();
        if (this.modulesKeyed.containsKey(clazz)) {
            throw new IllegalStateException("Module is already registered for class: " + clazz);
        }
        this.modulesKeyed.put(clazz, module);
        this.modules.add(module);
        if (module instanceof IPlayerAetherModule.Serializable) {
            this.modulesSerializable.add((IPlayerAetherModule.Serializable)((Object)module));
        }
    }

    @Override
    public <T extends IPlayerAetherModule> T getModule(Class<T> clazz) {
        IPlayerAetherModule ret = this.modulesKeyed.get(clazz);
        if (ret == null) {
            throw new NullPointerException("No module registered for class: " + clazz);
        }
        return (T)ret;
    }

    public ItemStack getLastDestroyedStack() {
        return this.lastDestroyedStack;
    }

    public void setLastDestroyedStack(ItemStack lastDestroyedStack) {
        this.lastDestroyedStack = lastDestroyedStack;
    }

    public void setDrankEggnog() {
        this.ticksWithEggnogEffect = 5000;
    }

    public boolean hasEggnogEffect() {
        return this.ticksWithEggnogEffect > 0;
    }

    public void setJumping(boolean jumping) {
        this.isJumping = jumping;
    }

    public boolean getJumping() {
        return this.isJumping;
    }

    public float getCooldownTracker() {
        return this.cooldownTracker;
    }

    public void onLoggedOut() {
        this.getModule(PlayerSectorModule.class).releaseAll();
    }

    public void sendFullUpdate() {
        EntityPlayerMP player = (EntityPlayerMP)this.getEntity();
        NetworkingAether.sendPacketToPlayer(new PacketCurrencyModule(this.getModule(PlayerCurrencyModule.class)), player);
        NetworkingAether.sendPacketToPlayer(new PacketProgressModule(this.getModule(PlayerProgressModule.class)), player);
        NetworkingAether.sendPacketToPlayer(new PacketSetPlayedIntro(this.getModule(PlayerTeleportingModule.class).hasPlayedIntro()), player);
        NetworkingAether.sendPacketToPlayer(new PacketCampfires(this.getModule(PlayerCampfiresModule.class).getCampfiresActivated()), player);
        NetworkingAether.sendPacketToPlayer(new PacketPreventDropsInventories(this.getModule(PlayerPreventDropsModule.class)), player);
        NetworkingAether.sendPacketToPlayer(new PacketPlayerConditionModule(this.getModule(PlayerConditionModule.class)), player);
        NetworkingAether.sendPacketToPlayer(new PacketEquipment(PlayerAether.getPlayer((EntityPlayer)player)), player);
    }

    public void onUpdate() {
        this.cooldownTracker = this.getEntity().func_184825_o(0.0f);
        if (this.ticksWithEggnogEffect > 0) {
            --this.ticksWithEggnogEffect;
        }
        if (this.getEntity().field_70181_x < 0.0) {
            this.setJumping(false);
        }
    }

    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        this.onUpdate();
        for (IPlayerAetherModule module : this.modules) {
            if (event.phase == TickEvent.Phase.START) {
                module.tickStart(event);
            }
            if (event.phase != TickEvent.Phase.END) continue;
            module.tickEnd(event);
        }
    }

    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.sendFullUpdate();
        for (IPlayerAetherModule module : this.modules) {
            module.onRespawn(event);
        }
    }

    public void onPlaceBlock(BlockEvent.PlaceEvent event) {
    }

    public void onDeath(LivingDeathEvent event) {
        for (IPlayerAetherModule module : this.modules) {
            module.onDeath(event);
        }
    }

    public void onDrops(PlayerDropsEvent event) {
        for (IPlayerAetherModule module : this.modules) {
            module.onDrops(event);
        }
    }

    public void onHurt(LivingHurtEvent event) {
        PlayerRollMovementModule movementModule;
        PlayerEquipmentModule equipmentModule = this.getModule(PlayerEquipmentModule.class);
        if (equipmentModule.getEffectPool(new ResourceLocation("aether", "fire_immunity")).isPresent() && (event.getSource() == DamageSource.field_76370_b || event.getSource() == DamageSource.field_76372_a || event.getSource() == DamageSource.field_76371_c)) {
            event.setCanceled(true);
        }
        if ((movementModule = this.getModule(PlayerRollMovementModule.class)).isRolling()) {
            event.setAmount(movementModule.getDamageReduction(event.getAmount()));
        }
    }

    public void onFall(LivingFallEvent event) {
        this.getModule(PlayerAbilitiesModule.class).onFall(event);
    }

    public void onTeleport(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.getModule(PlayerSectorModule.class).releaseAll();
        this.getModule(PlayerEquipmentModule.class).onTeleport();
        this.sendFullUpdate();
    }

    public void onPlayerBeginWatching(IPlayerAether other) {
        NetworkingAether.sendPacketToPlayer(new PacketEquipment(this), (EntityPlayerMP)other.getEntity());
    }

    @Override
    public float getMiningSpeedMultiplier() {
        if (this.getEntity().func_70086_ai() == 300 && this.getEntity().func_70644_a(MobEffects.field_76427_o) && !EnchantmentHelper.func_185287_i((EntityLivingBase)this.entity) && this.entity.func_70055_a(Material.field_151586_h)) {
            return 5.0f;
        }
        return 1.0f;
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        NBTTagCompound modules = new NBTTagCompound();
        for (IPlayerAetherModule.Serializable module : this.modulesSerializable) {
            modules.func_74782_a(module.getIdentifier().toString(), (NBTBase)NBTHelper.writeRaw((NBT)module));
        }
        tag.func_74782_a("Modules", (NBTBase)modules);
        funnel.set("towerInstance", (NBT)this.towerInstance);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        NBTTagCompound modules = tag.func_74775_l("Modules");
        for (IPlayerAetherModule.Serializable module : this.modulesSerializable) {
            String key = module.getIdentifier().toString();
            if (!modules.func_74764_b(key)) continue;
            module.read(modules.func_74775_l(key));
        }
        NecromancerTowerInstance inst = (NecromancerTowerInstance)funnel.get("towerInstance");
        if (inst != null) {
            this.towerInstance = inst;
        }
    }

    @Override
    public EntityPlayer getEntity() {
        return this.entity;
    }

    public static class Storage
    implements Capability.IStorage<IPlayerAether> {
        public NBTBase writeNBT(Capability<IPlayerAether> capability, IPlayerAether instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            instance.write(compound);
            return compound;
        }

        public void readNBT(Capability<IPlayerAether> capability, IPlayerAether instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            instance.read(compound);
        }
    }
}

