/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.effects;

import com.gildedgames.aether.api.entity.effects.IAetherStatusEffectPool;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.common.entities.effects.StatusEffectAmbrosiumPoisoning;
import com.gildedgames.aether.common.entities.effects.StatusEffectBleed;
import com.gildedgames.aether.common.entities.effects.StatusEffectCockatriceVenom;
import com.gildedgames.aether.common.entities.effects.StatusEffectFracture;
import com.gildedgames.aether.common.entities.effects.StatusEffectFreeze;
import com.gildedgames.aether.common.entities.effects.StatusEffectFungalRot;
import com.gildedgames.aether.common.entities.effects.StatusEffectStun;
import com.gildedgames.aether.common.entities.effects.StatusEffectToxin;
import com.gildedgames.aether.common.entities.effects.StatusEffectWebbing;
import com.gildedgames.aether.common.entities.effects.teas.StatusEffectSaturationBoost;
import com.gildedgames.aether.common.entities.effects.unique.StatusEffectGuardBreak;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class StatusEffectPool
implements IAetherStatusEffectPool {
    private static final HashMap<String, StatusEffectFactory> types = new HashMap();
    private EntityLivingBase livingBase;
    private HashMap<String, IAetherStatusEffects> activeEffects = new HashMap();

    public StatusEffectPool() throws InstantiationException {
        throw new InstantiationException("Do not use default constructor to instantiate pool!");
    }

    public StatusEffectPool(EntityLivingBase livingBase) {
        this.livingBase = livingBase;
    }

    @Override
    public void tick() {
        boolean creative;
        Iterator<Map.Entry<String, IAetherStatusEffects>> it = this.activeEffects.entrySet().iterator();
        boolean bl = creative = this.livingBase instanceof EntityPlayerMP && ((EntityPlayerMP)this.livingBase).func_184812_l_();
        while (it.hasNext()) {
            IAetherStatusEffects effect = it.next().getValue();
            if (creative && (effect.getIsEffectApplied() || effect.getBuildup() > 0)) {
                effect.resetEffect();
            }
            effect.tick(this.livingBase);
            if (!this.shouldRemoveEffect(effect)) continue;
            it.remove();
        }
    }

    private boolean shouldRemoveEffect(IAetherStatusEffects effect) {
        return !effect.isDirty() && !effect.getIsEffectApplied() && effect.getBuildup() == 0 && effect.getResistance() == 1.0;
    }

    @Override
    public void applyStatusEffect(IAetherStatusEffects.effectTypes effectType, int buildup) {
        IAetherStatusEffects ambroiumPoisoningEffect = this.getActiveEffect(IAetherStatusEffects.effectTypes.AMBROSIUM_POISONING.name);
        double additionalResistance = 0.0;
        if (ambroiumPoisoningEffect != null && ambroiumPoisoningEffect.getIsEffectApplied()) {
            additionalResistance = 0.5;
        }
        IAetherStatusEffects effect = this.createEffect(effectType.name, this.livingBase);
        effect.addBuildup(buildup, additionalResistance);
    }

    @Override
    public int getBuildupFromEffect(IAetherStatusEffects.effectTypes effectType) {
        IAetherStatusEffects effect = this.getActiveEffect(effectType.name);
        return effect != null ? effect.getBuildup() : 0;
    }

    @Override
    public boolean isEffectApplied(IAetherStatusEffects.effectTypes effectType) {
        IAetherStatusEffects effect = this.getActiveEffect(effectType.name);
        return effect != null && effect.getIsEffectApplied();
    }

    @Override
    public double getResistanceToEffect(IAetherStatusEffects.effectTypes effectType) {
        IAetherStatusEffects effect = this.getActiveEffect(effectType.name);
        if (effect != null) {
            return effect.getResistance();
        }
        return 1.0;
    }

    @Override
    public void addResistanceToEffect(IAetherStatusEffects.effectTypes effectType, double addResistance) {
        IAetherStatusEffects effect = this.getActiveEffect(effectType.name);
        if (effect != null) {
            effect.addResistance(addResistance);
        }
    }

    @Override
    public void resetResistanceToEffect(IAetherStatusEffects.effectTypes effectType) {
        IAetherStatusEffects effect = this.getActiveEffect(effectType.name);
        if (effect != null) {
            effect.resetResistance();
        }
    }

    @Override
    public void resetAllResistances() {
        for (IAetherStatusEffects effect : this.getActiveEffects()) {
            if (effect == null) continue;
            effect.resetResistance();
        }
    }

    @Override
    public void modifyActiveEffectTime(IAetherStatusEffects.effectTypes effectType, double activeEffectTimeModifier) {
        IAetherStatusEffects effect = this.getActiveEffect(effectType.name);
        if (effect != null) {
            effect.setActiveEffectTimeModifier(activeEffectTimeModifier);
        }
    }

    @Override
    public void modifyAllActiveEffectTimes(double activeEffectTimeModifier) {
        for (IAetherStatusEffects effect : this.getActiveEffects()) {
            if (effect == null) continue;
            effect.setActiveEffectTimeModifier(activeEffectTimeModifier);
        }
    }

    @Override
    public void modifyActiveEffectBuildup(IAetherStatusEffects.effectTypes effectType, int activeEffectBuildup) {
        IAetherStatusEffects effect = this.getActiveEffect(effectType.name);
        if (effect != null) {
            effect.setBuildup(activeEffectBuildup);
        }
    }

    @Override
    public void modifyActiveEffectApplication(IAetherStatusEffects.effectTypes effectType, boolean setApplied) {
        IAetherStatusEffects effect = this.getActiveEffect(effectType.name);
        if (effect != null) {
            effect.setApplied(setApplied);
        }
    }

    @Override
    public void cureActiveEffect(IAetherStatusEffects.effectTypes effectType) {
        IAetherStatusEffects effect = this.getActiveEffect(effectType.name);
        if (effect != null) {
            effect.setActiveEffectTimeModifier(0.0);
        }
    }

    @Override
    public void cureAllActiveEffects() {
        this.modifyAllActiveEffectTimes(0.0);
    }

    @Override
    public HashMap<String, IAetherStatusEffects> getPool() {
        return this.activeEffects;
    }

    public static IAetherStatusEffectPool get(EntityLivingBase livingBase) {
        return (IAetherStatusEffectPool)livingBase.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null);
    }

    private Collection<IAetherStatusEffects> getActiveEffects() {
        return this.activeEffects.values();
    }

    private IAetherStatusEffects getActiveEffect(String name) {
        return this.activeEffects.get(name);
    }

    @Override
    public IAetherStatusEffects createEffect(String name, EntityLivingBase entity) {
        return this.activeEffects.computeIfAbsent(name, key -> {
            StatusEffectFactory factory = types.get(name);
            if (factory == null) {
                throw new IllegalArgumentException("No factory registered for effect with name " + name);
            }
            return factory.create(entity);
        });
    }

    static {
        types.put(IAetherStatusEffects.effectTypes.AMBROSIUM_POISONING.name, new StatusEffectFactory(StatusEffectAmbrosiumPoisoning.class));
        types.put(IAetherStatusEffects.effectTypes.BLEED.name, new StatusEffectFactory(StatusEffectBleed.class));
        types.put(IAetherStatusEffects.effectTypes.COCKATRICE_VENOM.name, new StatusEffectFactory(StatusEffectCockatriceVenom.class));
        types.put(IAetherStatusEffects.effectTypes.FRACTURE.name, new StatusEffectFactory(StatusEffectFracture.class));
        types.put(IAetherStatusEffects.effectTypes.FUNGAL_ROT.name, new StatusEffectFactory(StatusEffectFungalRot.class));
        types.put(IAetherStatusEffects.effectTypes.STUN.name, new StatusEffectFactory(StatusEffectStun.class));
        types.put(IAetherStatusEffects.effectTypes.TOXIN.name, new StatusEffectFactory(StatusEffectToxin.class));
        types.put(IAetherStatusEffects.effectTypes.FREEZE.name, new StatusEffectFactory(StatusEffectFreeze.class));
        types.put(IAetherStatusEffects.effectTypes.WEBBING.name, new StatusEffectFactory(StatusEffectWebbing.class));
        types.put(IAetherStatusEffects.effectTypes.SATURATION_BOOST.name, new StatusEffectFactory(StatusEffectSaturationBoost.class));
        types.put(IAetherStatusEffects.effectTypes.GUARD_BREAK.name, new StatusEffectFactory(StatusEffectGuardBreak.class));
    }

    private static class StatusEffectFactory {
        private final Constructor<? extends IAetherStatusEffects> constructor;

        public StatusEffectFactory(Class<? extends IAetherStatusEffects> clazz) {
            try {
                this.constructor = clazz.getConstructor(EntityLivingBase.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Couldn't find constructor for status effect " + clazz);
            }
        }

        public IAetherStatusEffects create(EntityLivingBase entity) {
            try {
                return this.constructor.newInstance(entity);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Failed to instantiate effect", e);
            }
        }
    }

    public static class Storage
    implements Capability.IStorage<IAetherStatusEffectPool> {
        @Nullable
        public NBTBase writeNBT(Capability<IAetherStatusEffectPool> capability, IAetherStatusEffectPool instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            for (IAetherStatusEffects effect : instance.getPool().values()) {
                effect.write(compound);
            }
            return compound;
        }

        public void readNBT(Capability<IAetherStatusEffectPool> capability, IAetherStatusEffectPool instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            for (IAetherStatusEffects effect : instance.getPool().values()) {
                effect.read(tag);
            }
        }
    }
}

