/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities;

import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.entity.damage.IDamageLevelsHolder;
import com.gildedgames.aether.api.entity.damage.IDefenseLevelsHolder;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerEquipmentModule;
import com.gildedgames.aether.common.init.ParticlesAether;
import com.gildedgames.aether.common.items.armor.ItemAetherGloves;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketParticles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class DamageSystem {
    public static boolean blocked;
    public static int timer;

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (blocked && ++timer > 10) {
            blocked = false;
            timer = 0;
        }
    }

    @SubscribeEvent
    public static void onLivingEntityHurt(LivingHurtEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        if (target instanceof IDefenseLevelsHolder) {
            if (event.getSource().func_76364_f() instanceof EntityPlayer) {
                EntityPlayer source = (EntityPlayer)event.getSource().func_76364_f();
                ItemStack gloveStack = PlayerAether.getPlayer(source).getModule(PlayerEquipmentModule.class).getInventory().func_70301_a(2);
                if (source.func_184614_ca().func_77973_b() instanceof IDamageLevelsHolder) {
                    float damageAmount;
                    IDamageLevelsHolder itemMainhand = (IDamageLevelsHolder)source.func_184614_ca().func_77973_b();
                    float slashDamage = 0.0f;
                    float pierceDamage = 0.0f;
                    float impactDamage = 0.0f;
                    float bonusSlash = 0.0f;
                    float bonusPierce = 0.0f;
                    float bonusImpact = 0.0f;
                    if (source.func_184614_ca().func_77973_b() == ItemsAether.zanite_sword) {
                        bonusSlash = (float)(source.func_184614_ca().func_77952_i() * 4) / (float)source.func_184614_ca().func_77973_b().func_77612_l();
                    }
                    if (itemMainhand.getSlashDamageLevel() > 0.0f) {
                        damageAmount = (float)((double)itemMainhand.getSlashDamageLevel() + target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e() + (double)bonusSlash);
                        slashDamage = Math.max(damageAmount, 1.0f);
                    }
                    if (itemMainhand.getPierceDamageLevel() > 0.0f) {
                        damageAmount = (float)((double)itemMainhand.getPierceDamageLevel() + target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e() + (double)bonusPierce);
                        pierceDamage = Math.max(damageAmount, 1.0f);
                    }
                    if (itemMainhand.getImpactDamageLevel() > 0.0f) {
                        damageAmount = (float)((double)itemMainhand.getImpactDamageLevel() + target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e() + (double)bonusImpact);
                        impactDamage = Math.max(damageAmount, 1.0f);
                    }
                    float totalDamage = slashDamage + pierceDamage + impactDamage;
                    float cooldownTracker = PlayerAether.getPlayer(source).getCooldownTracker();
                    event.setAmount(totalDamage * cooldownTracker);
                    DamageSystem.spawnParticles(target, itemMainhand.getSlashDamageLevel(), itemMainhand.getPierceDamageLevel(), itemMainhand.getImpactDamageLevel(), target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e());
                    DamageSystem.handleSounds(target, itemMainhand.getSlashDamageLevel(), itemMainhand.getPierceDamageLevel(), itemMainhand.getImpactDamageLevel(), target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e());
                } else if (source.func_184592_cb().func_77973_b() instanceof IDamageLevelsHolder) {
                    float damageAmount;
                    IDamageLevelsHolder itemOffhand = (IDamageLevelsHolder)source.func_184592_cb().func_77973_b();
                    float slashDamage = 0.0f;
                    float pierceDamage = 0.0f;
                    float impactDamage = 0.0f;
                    float bonusSlash = 0.0f;
                    float bonusPierce = 0.0f;
                    float bonusImpact = 0.0f;
                    if (source.func_184614_ca().func_77973_b() == ItemsAether.zanite_sword) {
                        bonusSlash = (float)(source.func_184614_ca().func_77952_i() * 4) / (float)source.func_184614_ca().func_77973_b().func_77612_l();
                    }
                    if (itemOffhand.getSlashDamageLevel() > 0.0f) {
                        damageAmount = (float)((double)itemOffhand.getSlashDamageLevel() + target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e() + (double)bonusSlash);
                        slashDamage = Math.max(damageAmount, 1.0f);
                    }
                    if (itemOffhand.getPierceDamageLevel() > 0.0f) {
                        damageAmount = (float)((double)itemOffhand.getPierceDamageLevel() + target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e() + (double)bonusPierce);
                        pierceDamage = Math.max(damageAmount, 1.0f);
                    }
                    if (itemOffhand.getImpactDamageLevel() > 0.0f) {
                        damageAmount = (float)((double)itemOffhand.getImpactDamageLevel() + target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e() + (double)bonusImpact);
                        impactDamage = Math.max(damageAmount, 1.0f);
                    }
                    float totalDamage = slashDamage + pierceDamage + impactDamage;
                    float cooldownTracker = PlayerAether.getPlayer(source).getCooldownTracker();
                    event.setAmount(totalDamage * cooldownTracker);
                    DamageSystem.spawnParticles(target, itemOffhand.getSlashDamageLevel(), itemOffhand.getPierceDamageLevel(), itemOffhand.getImpactDamageLevel(), target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e());
                    DamageSystem.handleSounds(target, itemOffhand.getSlashDamageLevel(), itemOffhand.getPierceDamageLevel(), itemOffhand.getImpactDamageLevel(), target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e());
                } else if (source.func_184614_ca().func_190926_b() && gloveStack.func_77973_b() instanceof ItemAetherGloves && !gloveStack.func_190926_b()) {
                    float damageAmount;
                    ItemAetherGloves gloves = (ItemAetherGloves)gloveStack.func_77973_b();
                    float slashDamage = 0.0f;
                    float pierceDamage = 0.0f;
                    float impactDamage = 0.0f;
                    float bonusSlash = 0.0f;
                    float bonusPierce = 0.0f;
                    float bonusImpact = 0.0f;
                    if (gloveStack.func_77973_b() == ItemsAether.zanite_gloves) {
                        bonusImpact = (float)(gloveStack.func_77952_i() * 4) / (float)gloveStack.func_77973_b().func_77612_l();
                    }
                    if (gloves.getSlashDamageLevel() > 0.0f) {
                        damageAmount = (float)((double)gloves.getSlashDamageLevel() + target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e() + (double)bonusSlash);
                        slashDamage = Math.max(damageAmount, 1.0f);
                    }
                    if (gloves.getPierceDamageLevel() > 0.0f) {
                        damageAmount = (float)((double)gloves.getPierceDamageLevel() + target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e() + (double)bonusPierce);
                        pierceDamage = Math.max(damageAmount, 1.0f);
                    }
                    if (gloves.getImpactDamageLevel() > 0.0f) {
                        damageAmount = (float)((double)gloves.getImpactDamageLevel() + target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e() + (double)bonusImpact);
                        impactDamage = Math.max(damageAmount, 1.0f);
                    }
                    float totalDamage = slashDamage + pierceDamage + impactDamage;
                    float cooldownTracker = PlayerAether.getPlayer(source).getCooldownTracker();
                    event.setAmount(totalDamage * cooldownTracker);
                    DamageSystem.spawnParticles(target, gloves.getSlashDamageLevel(), gloves.getPierceDamageLevel(), gloves.getImpactDamageLevel(), target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e());
                    DamageSystem.handleSounds(target, gloves.getSlashDamageLevel(), gloves.getPierceDamageLevel(), gloves.getImpactDamageLevel(), target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e());
                } else {
                    float damageAmount = Math.max(event.getAmount() - 4.0f, 1.0f);
                    event.setAmount(damageAmount);
                }
            } else if (event.getSource().func_76364_f() instanceof IDamageLevelsHolder) {
                float damageAmount;
                IDamageLevelsHolder entitySource = (IDamageLevelsHolder)event.getSource().func_76364_f();
                float slashDamage = 0.0f;
                float pierceDamage = 0.0f;
                float impactDamage = 0.0f;
                if (entitySource.getSlashDamageLevel() > 0.0f) {
                    damageAmount = (float)((double)entitySource.getSlashDamageLevel() + target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e());
                    slashDamage = Math.max(damageAmount, 1.0f);
                }
                if (entitySource.getPierceDamageLevel() > 0.0f) {
                    damageAmount = (float)((double)entitySource.getPierceDamageLevel() + target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e());
                    pierceDamage = Math.max(damageAmount, 1.0f);
                }
                if (entitySource.getImpactDamageLevel() > 0.0f) {
                    damageAmount = (float)((double)entitySource.getImpactDamageLevel() + target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e());
                    impactDamage = Math.max(damageAmount, 1.0f);
                }
                float totalDamage = slashDamage + pierceDamage + impactDamage;
                event.setAmount(totalDamage);
                DamageSystem.spawnParticles(target, entitySource.getSlashDamageLevel(), entitySource.getPierceDamageLevel(), entitySource.getImpactDamageLevel(), target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e());
                DamageSystem.handleSounds(target, entitySource.getSlashDamageLevel(), entitySource.getPierceDamageLevel(), entitySource.getImpactDamageLevel(), target.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e(), target.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e());
            } else {
                float damageAmount = Math.max(event.getAmount() - 4.0f, 1.0f);
                event.setAmount(damageAmount);
            }
        }
    }

    @SubscribeEvent
    public static void handleVanillaGloveDamage(LivingHurtEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        if (!(target instanceof IDefenseLevelsHolder) && event.getSource().func_76364_f() instanceof EntityPlayer) {
            EntityPlayer source = (EntityPlayer)event.getSource().func_76364_f();
            ItemStack gloveStack = PlayerAether.getPlayer(source).getModule(PlayerEquipmentModule.class).getInventory().func_70301_a(2);
            if (source.func_184614_ca().func_190926_b() && gloveStack.func_77973_b() instanceof ItemAetherGloves && !gloveStack.func_190926_b()) {
                ItemAetherGloves gloves = (ItemAetherGloves)gloveStack.func_77973_b();
                float vanillaDamage = 0.0f;
                if (gloveStack.func_77973_b() == ItemsAether.zanite_gloves) {
                    vanillaDamage = 6.0f + (float)(gloveStack.func_77952_i() * 4) / (float)gloveStack.func_77973_b().func_77612_l();
                } else {
                    if (gloves.getSlashDamageLevel() > 0.0f) {
                        vanillaDamage = gloves.getSlashDamageLevel();
                    }
                    if (gloves.getPierceDamageLevel() > 0.0f) {
                        vanillaDamage = gloves.getPierceDamageLevel();
                    }
                    if (gloves.getImpactDamageLevel() > 0.0f) {
                        vanillaDamage = gloves.getImpactDamageLevel();
                    }
                }
                event.setAmount(vanillaDamage);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLoad(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)event.getObject();
            living.func_110140_aT().func_111150_b(DamageTypeAttributes.SLASH_DEFENSE_LEVEL);
            living.func_110140_aT().func_111150_b(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL);
            living.func_110140_aT().func_111150_b(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL);
        }
    }

    public static void spawnParticles(EntityLivingBase target, double slashDamage, double pierceDamage, double impactDamage, double slashDefense, double pierceDefense, double impactDefense) {
        double radius = 0.3;
        double randX = target.func_70681_au().nextDouble() * (target.func_70681_au().nextBoolean() ? 1.0 : -1.0) * 0.3;
        double randZ = target.func_70681_au().nextDouble() * (target.func_70681_au().nextBoolean() ? 1.0 : -1.0) * 0.3;
        double x = target.field_70165_t + randX;
        double y = target.field_70163_u + (double)target.field_70131_O;
        double z = target.field_70161_v + randZ;
        for (int i = 0; i < 20; ++i) {
            if (!(slashDamage > 0.0 && slashDefense > 0.0 || pierceDamage > 0.0 && pierceDefense > 0.0) && (!(impactDamage > 0.0) || !(impactDefense > 0.0))) continue;
            if (slashDamage > 0.0 && slashDefense > 0.0) {
                NetworkingAether.sendPacketToDimension(new PacketParticles(ParticlesAether.SLASH, x, y, z, randX, 0.0, randZ), target.field_71093_bK);
            }
            if (pierceDamage > 0.0 && pierceDefense > 0.0) {
                NetworkingAether.sendPacketToDimension(new PacketParticles(ParticlesAether.PIERCE, x, y, z, randX, 0.0, randZ), target.field_71093_bK);
            }
            if (impactDamage > 0.0 && impactDefense > 0.0) {
                NetworkingAether.sendPacketToDimension(new PacketParticles(ParticlesAether.IMPACT, x, y, z, randX, 0.0, randZ), target.field_71093_bK);
            }
            DamageSystem.handleSounds(target, slashDamage, pierceDamage, impactDamage, slashDefense, pierceDefense, impactDefense);
        }
    }

    public static void handleSounds(EntityLivingBase target, double slashDamage, double pierceDamage, double impactDamage, double slashDefense, double pierceDefense, double impactDefense) {
        if (slashDamage > 0.0 && slashDefense < 0.0 || pierceDamage > 0.0 && pierceDefense < 0.0 || impactDamage > 0.0 && impactDefense < 0.0) {
            blocked = true;
            target.func_184185_a(SoundEvents.field_187767_eL, 0.8f, 0.8f + target.field_70170_p.field_73012_v.nextFloat() * 0.4f);
        } else {
            blocked = false;
            if (slashDamage > 0.0 && slashDefense > 0.0 || pierceDamage > 0.0 && pierceDefense > 0.0 || impactDamage > 0.0 && impactDefense > 0.0) {
                target.func_184185_a(SoundEvents.field_187718_dS, 0.8f, 0.8f + target.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }
}

