/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.cache;

import com.gildedgames.aether.api.cache.IEntityStats;
import com.gildedgames.aether.api.cache.IEntityStatsCache;
import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.common.cache.EntityStats;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityStatsCache
implements IEntityStatsCache {
    private final Map<ResourceLocation, IEntityStats> entityIdToStats = Maps.newHashMap();

    @Override
    public IEntityStats getStats(ResourceLocation entityId) {
        if (!this.entityIdToStats.containsKey(entityId)) {
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entityId);
            if (entityEntry == null) {
                throw new RuntimeException("Entity entry cannot be found with given entityId: " + entityId);
            }
            Entity entity = entityEntry.newInstance(null);
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)entity;
                double slashDefenseLevel = living.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111126_e();
                double pierceDefenseLevel = living.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111126_e();
                double impactDefenseLevel = living.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111126_e();
                EntityStats stats = EntityStats.build().maxHealth(living.func_110138_aP()).slashDefenseLevel(slashDefenseLevel).pierceDefenseLevel(pierceDefenseLevel).impactDefenseLevel(impactDefenseLevel).flush();
                this.entityIdToStats.put(entityId, stats);
            }
        }
        return this.entityIdToStats.get(entityId);
    }
}

