/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.cache;

import com.gildedgames.aether.api.cache.IEntityStats;

public class EntityStats
implements IEntityStats {
    private final float maxHealth;
    private final double slashDefenseLevel;
    private final double pierceDefenseLevel;
    private final double impactDefenseLevel;

    private EntityStats(float maxHealth, double slashDefenseLevel, double pierceDefenseLevel, double impactDefenseLevel) {
        this.maxHealth = maxHealth;
        this.slashDefenseLevel = slashDefenseLevel;
        this.pierceDefenseLevel = pierceDefenseLevel;
        this.impactDefenseLevel = impactDefenseLevel;
    }

    public static EntityStatsFactory build() {
        return new EntityStatsFactory();
    }

    @Override
    public float getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public double getSlashDefenseLevel() {
        return this.slashDefenseLevel;
    }

    @Override
    public double getPierceDefenseLevel() {
        return this.pierceDefenseLevel;
    }

    @Override
    public double getImpactDefenseLevel() {
        return this.impactDefenseLevel;
    }

    public static class EntityStatsFactory {
        private float maxHealth;
        private double slashDefenseLevel;
        private double pierceDefenseLevel;
        private double impactDefenseLevel;

        private EntityStatsFactory() {
        }

        public EntityStatsFactory maxHealth(float value) {
            this.maxHealth = value;
            return this;
        }

        public EntityStatsFactory slashDefenseLevel(double value) {
            this.slashDefenseLevel = value;
            return this;
        }

        public EntityStatsFactory pierceDefenseLevel(double value) {
            this.pierceDefenseLevel = value;
            return this;
        }

        public EntityStatsFactory impactDefenseLevel(double value) {
            this.impactDefenseLevel = value;
            return this;
        }

        public EntityStats flush() {
            return new EntityStats(this.maxHealth, this.slashDefenseLevel, this.pierceDefenseLevel, this.impactDefenseLevel);
        }
    }
}

