/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.util;

import com.gildedgames.aether.common.entities.blocks.EntityFloatingBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockFloating
extends Block {
    public BlockFloating(Material material) {
        super(material);
    }

    public static boolean canFallInto(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        return state.func_177230_c() == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            this.checkFallable(world, pos);
        }
    }

    private void checkFallable(World world, BlockPos pos) {
        boolean floatInstantly = BlockSand.field_149832_M;
        if (BlockFloating.canFallInto(world, pos.func_177984_a()) && pos.func_177956_o() >= 0) {
            int b0 = 32;
            if (!floatInstantly && world.func_175707_a(pos.func_177982_a(-b0, -b0, -b0), pos.func_177982_a(b0, b0, b0))) {
                if (!world.field_72995_K) {
                    EntityFloatingBlock entity = new EntityFloatingBlock(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
                    world.func_72838_d((Entity)entity);
                }
            } else {
                world.func_175698_g(pos);
                BlockPos bottomPos = pos.func_177977_b();
                while (BlockFloating.canFallInto(world, bottomPos) && bottomPos.func_177956_o() > 0) {
                    bottomPos = bottomPos.func_177977_b();
                }
                if (bottomPos.func_177956_o() > 0) {
                    world.func_175656_a(bottomPos.func_177984_a(), this.func_176223_P());
                }
            }
        }
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }
}

