/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.util;

import com.gildedgames.aether.common.blocks.IBlockWithItem;
import com.gildedgames.aether.common.items.blocks.ItemBlockCustomSlab;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCustomSlab
extends Block
implements IBlockWithItem {
    public static final PropertyEnum<EnumSlabPart> PROPERTY_SLAB_STATE = PropertyEnum.func_177709_a((String)"state", EnumSlabPart.class);
    private static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    public BlockCustomSlab(Material material) {
        super(material);
        this.func_149713_g(0);
        this.field_149783_u = true;
    }

    public BlockCustomSlab setSoundType(SoundType type) {
        super.func_149672_a(type);
        return this;
    }

    public int func_149717_k(IBlockState state) {
        return state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.FULL_BLOCK ? 255 : 0;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (state.func_185914_p()) {
            return true;
        }
        EnumSlabPart slabState = (EnumSlabPart)((Object)state.func_177229_b(PROPERTY_SLAB_STATE));
        return slabState == EnumSlabPart.TOP_HALF && face == EnumFacing.UP || slabState == EnumSlabPart.BOTTOM_HALF && face == EnumFacing.DOWN;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PROPERTY_SLAB_STATE, (Comparable)((Object)EnumSlabPart.VALUES[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumSlabPart)((Object)state.func_177229_b(PROPERTY_SLAB_STATE))).ordinal();
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.FULL_BLOCK;
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.FULL_BLOCK;
    }

    public boolean func_149662_c(IBlockState state) {
        return state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.FULL_BLOCK;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.FULL_BLOCK ? 2 : 1;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumSlabPart)((Object)state.func_177229_b(PROPERTY_SLAB_STATE))) {
            case BOTTOM_HALF: {
                return AABB_BOTTOM_HALF;
            }
            case TOP_HALF: {
                return AABB_TOP_HALF;
            }
        }
        return field_185505_j;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176223_P().func_177226_a(PROPERTY_SLAB_STATE, (Comparable)((Object)EnumSlabPart.BOTTOM_HALF));
        if (state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.FULL_BLOCK) {
            return state;
        }
        if (facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5)) {
            return state.func_177226_a(PROPERTY_SLAB_STATE, (Comparable)((Object)EnumSlabPart.BOTTOM_HALF));
        }
        return state.func_177226_a(PROPERTY_SLAB_STATE, (Comparable)((Object)EnumSlabPart.TOP_HALF));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.FULL_BLOCK) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.UP && state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.TOP_HALF) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.DOWN && state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.BOTTOM_HALF) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.TOP_HALF || state.func_177229_b(PROPERTY_SLAB_STATE) == EnumSlabPart.FULL_BLOCK;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_SLAB_STATE});
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockCustomSlab(this);
    }

    public static enum EnumSlabPart implements IStringSerializable
    {
        BOTTOM_HALF("bottom"),
        TOP_HALF("top"),
        FULL_BLOCK("full");

        public static final EnumSlabPart[] VALUES;
        private final String name;

        private EnumSlabPart(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            VALUES = EnumSlabPart.values();
        }
    }
}

