/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.properties;

import com.gildedgames.aether.common.blocks.properties.BlockVariant;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.properties.IProperty;

public class PropertyVariant
implements IProperty<BlockVariant> {
    private final String name;
    private final BlockVariant[] mappings;
    private final HashMap<String, BlockVariant> entries;
    private final List<BlockVariant> values = new ArrayList<BlockVariant>();

    protected PropertyVariant(String name, BlockVariant ... variants) {
        if (variants.length <= 0) {
            throw new RuntimeException("At least one variant must be supplied");
        }
        this.name = name;
        this.mappings = variants;
        this.entries = new HashMap();
        for (BlockVariant variant : variants) {
            this.entries.put(variant.getName(), variant);
            this.values.add(variant);
        }
    }

    public static PropertyVariant create(String name, BlockVariant ... variants) {
        return new PropertyVariant(name, variants);
    }

    public String func_177701_a() {
        return this.name;
    }

    public Collection<BlockVariant> func_177700_c() {
        return this.entries.values();
    }

    public Class<BlockVariant> func_177699_b() {
        return BlockVariant.class;
    }

    public Optional<BlockVariant> func_185929_b(String value) {
        return Optional.fromNullable((Object)this.entries.get(value));
    }

    public String getName(BlockVariant value) {
        return value.getName();
    }

    public BlockVariant fromMeta(int meta) {
        if (meta < 0 || meta > this.mappings.length) {
            return this.mappings[0];
        }
        return this.mappings[meta];
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PropertyVariant && super.equals(other)) {
            PropertyVariant otherProperty = (PropertyVariant)other;
            return this.values.equals(otherProperty.values) && this.entries.equals(otherProperty.entries);
        }
        return false;
    }

    public int hashCode() {
        int i = super.hashCode();
        i = 31 * i + this.values.hashCode();
        i = 31 * i + this.entries.hashCode();
        return i;
    }
}

