/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural.plants.saplings;

import com.gildedgames.aether.common.blocks.IBlockMultiName;
import com.gildedgames.aether.common.blocks.IBlockWithItem;
import com.gildedgames.aether.common.blocks.natural.plants.BlockAetherPlant;
import com.gildedgames.aether.common.blocks.properties.BlockVariant;
import com.gildedgames.aether.common.blocks.properties.PropertyVariant;
import com.gildedgames.aether.common.items.blocks.ItemBlockCustomSapling;
import com.gildedgames.orbis.lib.core.BlueprintDefinition;
import com.gildedgames.orbis.lib.core.CreationData;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprint;
import com.gildedgames.orbis.lib.core.util.BlueprintPlacer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockAetherSapling
extends BlockAetherPlant
implements IGrowable,
IBlockMultiName,
IBlockWithItem {
    public static final PropertyInteger PROPERTY_STAGE = PropertyInteger.func_177719_a((String)"growth_stage", (int)0, (int)1);
    private static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);

    public BlockAetherSapling() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    @Override
    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        BlueprintDefinition tree;
        if ((Integer)state.func_177229_b((IProperty)PROPERTY_STAGE) == 0) {
            world.func_180501_a(pos, state.func_177231_a((IProperty)PROPERTY_STAGE), 4);
            return;
        }
        if (TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos) && (tree = this.getBlueprint(state)) != null) {
            BlockPos adjustedPos = pos.func_177971_a((Vec3i)this.getBlueprintOffset(state));
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
            BakedBlueprint baked = new BakedBlueprint(tree, (ICreationData)new CreationData(world).pos(BlockPos.field_177992_a).placesAir(false).placesVoid(false));
            if (!BlueprintPlacer.place((World)world, (BakedBlueprint)baked, (BlockPos)adjustedPos)) {
                world.func_180501_a(pos, state, 4);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BlockVariant variant : this.getPropertyVariant().func_177700_c()) {
            list.add((Object)new ItemStack((Block)this, 1, variant.getMeta()));
        }
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        return this.getPropertyVariant().fromMeta(stack.func_77960_j()).getName();
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)this.getPropertyVariant())).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.getPropertyVariant(), (Comparable)this.getPropertyVariant().fromMeta(meta & 7)).func_177226_a((IProperty)PROPERTY_STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)this.getPropertyVariant())).getMeta() | (Integer)state.func_177229_b((IProperty)PROPERTY_STAGE) << 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyVariant(), PROPERTY_STAGE});
    }

    @Override
    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    @Override
    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return rand.nextFloat() < 0.45f;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockCustomSapling(this);
    }

    public abstract BlueprintDefinition getBlueprint(IBlockState var1);

    public abstract BlockPos getBlueprintOffset(IBlockState var1);

    public abstract PropertyVariant getPropertyVariant();
}

