/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural.plants;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.blocks.IBlockMultiName;
import com.gildedgames.aether.common.blocks.natural.BlockAetherGrass;
import com.gildedgames.aether.common.blocks.natural.plants.BlockAetherPlant;
import com.gildedgames.aether.common.blocks.properties.BlockVariant;
import com.gildedgames.aether.common.blocks.properties.PropertyVariant;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockValkyrieGrass
extends BlockAetherPlant
implements IBlockMultiName,
IGrowable {
    public static final BlockVariant SPROUT = new BlockVariant(0, "sprout");
    public static final BlockVariant MID = new BlockVariant(1, "mid");
    public static final BlockVariant FULL = new BlockVariant(2, "full");
    public static final PropertyVariant PROPERTY_VARIANT = PropertyVariant.create("variant", SPROUT, MID, FULL);
    public static final PropertyBool PROPERTY_HARVESTABLE = PropertyBool.func_177716_a((String)"harvestable");
    private static final AxisAlignedBB GRASS_SHORT_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.3, 0.9);
    private static final AxisAlignedBB GRASS_NORMAL_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.6, 0.9);
    private static final AxisAlignedBB GRASS_LONG_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.9, 0.9);
    private static final int VALKYRIE_GRASS_SPROUT = 0;
    private static final int VALKYRIE_GRASS_MID = 1;
    private static final int VALKYRIE_GRASS_FULL = 2;

    public BlockValkyrieGrass() {
        super(Material.field_151585_k);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)FULL).func_177226_a((IProperty)PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(true)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_VARIANT, PROPERTY_HARVESTABLE});
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)PROPERTY_VARIANT.fromMeta(meta));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (placer.func_184614_ca().func_77960_j() == 2) {
            return this.func_176203_a(meta).func_177226_a((IProperty)PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)FULL);
        }
        return this.func_176203_a(meta).func_177226_a((IProperty)PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)SPROUT);
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        return PROPERTY_VARIANT.fromMeta(stack.func_77960_j()).getName();
    }

    @Override
    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE) == false;
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE) == false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!((Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE)).booleanValue() && world.func_175699_k(pos) >= 9 && rand.nextInt(60) == 0) {
            this.func_176474_b(world, rand, pos, state);
        }
    }

    @Override
    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE)).booleanValue()) {
            if (((BlockVariant)worldIn.func_180495_p(pos).func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta() == 0) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)MID));
            } else if (((BlockVariant)worldIn.func_180495_p(pos).func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta() == 1) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)FULL));
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == SPROUT) {
            return GRASS_SHORT_AABB;
        }
        if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == MID) {
            return GRASS_NORMAL_AABB;
        }
        if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == FULL) {
            return GRASS_LONG_AABB;
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (((Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE)).booleanValue()) {
            if (player.field_71075_bZ.field_75098_d) {
                world.func_175698_g(pos);
                return false;
            }
            if (!world.field_72995_K) {
                for (ItemStack item : this.getWingDrops((IBlockAccess)world, pos, state)) {
                    Random random = new Random();
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
                    if (random.nextInt(3) != 1) continue;
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(BlocksAether.valkyrie_grass));
                }
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(false)));
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    protected void invalidateBlock(World world, BlockPos pos, IBlockState state) {
        if (world.func_175623_d(pos.func_177977_b())) {
            world.func_175698_g(pos);
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(BlocksAether.valkyrie_grass));
            for (ItemStack item : this.getWingDrops((IBlockAccess)world, pos, state)) {
                Random random = new Random();
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
                if (random.nextInt(3) != 1) continue;
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(BlocksAether.valkyrie_grass));
            }
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List items = super.getDrops(world, pos, state, fortune);
        items.addAll(this.getWingDrops(world, pos, state));
        return items;
    }

    private List<ItemStack> getWingDrops(IBlockAccess world, BlockPos pos, IBlockState state) {
        boolean applyBonus;
        IBlockState stateUnderneath = world.func_180495_p(pos.func_177977_b());
        boolean bl = applyBonus = stateUnderneath.func_177230_c() == BlocksAether.aether_grass && stateUnderneath.func_177229_b((IProperty)BlockAetherGrass.PROPERTY_VARIANT) == BlockAetherGrass.ENCHANTED;
        int count = (Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE) != false ? 1 + (applyBonus ? 1 : 0) : 0;
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(ItemsAether.valkyrie_wings, count)});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BlockVariant variant : PROPERTY_VARIANT.func_177700_c()) {
            if (variant == MID) continue;
            list.add((Object)new ItemStack((Block)this, 1, variant.getMeta()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }
}

