/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural.plants;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.blocks.IBlockMultiName;
import com.gildedgames.aether.common.blocks.IBlockSnowy;
import com.gildedgames.aether.common.blocks.natural.BlockAetherGrass;
import com.gildedgames.aether.common.blocks.natural.plants.BlockAetherPlant;
import com.gildedgames.aether.common.blocks.properties.BlockVariant;
import com.gildedgames.aether.common.blocks.properties.PropertyVariant;
import com.gildedgames.aether.common.world.biomes.arctic_peaks.BiomeArcticPeaks;
import com.gildedgames.aether.common.world.biomes.irradiated_forests.BiomeIrradiatedForests;
import com.gildedgames.aether.common.world.biomes.magnetic_hills.BiomeMagneticHills;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTallAetherGrass
extends BlockAetherPlant
implements IBlockMultiName,
IBlockSnowy {
    public static final BlockVariant SHORT = new BlockVariant(0, "short");
    public static final BlockVariant NORMAL = new BlockVariant(1, "normal");
    public static final BlockVariant LONG = new BlockVariant(2, "long");
    public static final PropertyVariant PROPERTY_VARIANT = PropertyVariant.create("variant", SHORT, NORMAL, LONG);
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177706_a((String)"type", Type.class, (Enum[])new Type[]{Type.HIGHLANDS, Type.ENCHANTED, Type.ARCTIC, Type.MAGNETIC, Type.IRRADIATED});
    private static final AxisAlignedBB GRASS_SHORT_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.3, 0.9);
    private static final AxisAlignedBB GRASS_NORMAL_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.6, 0.9);
    private static final AxisAlignedBB GRASS_LONG_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.9, 0.9);

    public BlockTallAetherGrass() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)SHORT).func_177226_a(TYPE, (Comparable)((Object)Type.HIGHLANDS)).func_177226_a((IProperty)PROPERTY_SNOWY, (Comparable)Boolean.FALSE));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (worldIn.func_175642_b(EnumSkyBlock.BLOCK, pos) > 11 && ((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY)).booleanValue()) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)PROPERTY_SNOWY, (Comparable)Boolean.FALSE), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BlockVariant variant : PROPERTY_VARIANT.func_177700_c()) {
            list.add((Object)new ItemStack((Block)this, 1, variant.getMeta()));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (AetherCore.isClient()) {
            IBlockState lastVariant;
            IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
            Block bottomBlock = down.func_177230_c();
            Comparable grassType = (Comparable)down.func_177228_b().get((Object)BlockAetherGrass.PROPERTY_VARIANT);
            Biome biome = worldIn.func_180494_b(pos);
            IBlockState iBlockState = biome instanceof BiomeArcticPeaks ? state.func_177226_a(TYPE, (Comparable)((Object)Type.ARCTIC)) : (biome instanceof BiomeMagneticHills ? state.func_177226_a(TYPE, (Comparable)((Object)Type.MAGNETIC)) : (lastVariant = biome instanceof BiomeIrradiatedForests ? state.func_177226_a(TYPE, (Comparable)((Object)Type.IRRADIATED)) : state.func_177226_a(TYPE, (Comparable)((Object)Type.HIGHLANDS))));
            if (bottomBlock == BlocksAether.aether_grass) {
                return grassType.equals(BlockAetherGrass.ARCTIC) ? state.func_177226_a(TYPE, (Comparable)((Object)Type.ARCTIC)) : (grassType.equals(BlockAetherGrass.MAGNETIC) ? state.func_177226_a(TYPE, (Comparable)((Object)Type.MAGNETIC)) : (grassType.equals(BlockAetherGrass.IRRADIATED) ? state.func_177226_a(TYPE, (Comparable)((Object)Type.IRRADIATED)) : (grassType.equals(BlockAetherGrass.ENCHANTED) ? state.func_177226_a(TYPE, (Comparable)((Object)Type.ENCHANTED)) : state.func_177226_a(TYPE, (Comparable)((Object)Type.HIGHLANDS)))));
            }
            return lastVariant;
        }
        return state;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!(player.func_184614_ca().func_77973_b() != ItemsAether.arkenium_shears && player.func_184614_ca().func_77973_b() != Items.field_151097_aZ || player.func_184812_l_())) {
            if (((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY)).booleanValue()) {
                worldIn.func_180501_a(pos, BlocksAether.highlands_snow_layer.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(1)), 2);
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1, this.func_176201_c(state) - ((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY) != false ? PROPERTY_VARIANT.func_177700_c().size() : 0)));
            } else {
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176221_a(state, (IBlockAccess)worldIn, pos))));
            }
        }
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY)).booleanValue() && worldIn.func_180495_p(pos.func_177977_b()) != Blocks.field_150350_a.func_176223_P()) {
            worldIn.func_180501_a(pos, BlocksAether.highlands_snow_layer.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == SHORT) {
            return GRASS_SHORT_AABB;
        }
        if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == NORMAL) {
            return GRASS_NORMAL_AABB;
        }
        if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == LONG) {
            return GRASS_LONG_AABB;
        }
        return super.func_185496_a(state, source, pos);
    }

    public IBlockState func_176203_a(int meta) {
        boolean snowy = meta >= PROPERTY_VARIANT.func_177700_c().size();
        BlockVariant variant = PROPERTY_VARIANT.fromMeta(meta - (snowy ? PROPERTY_VARIANT.func_177700_c().size() : 0));
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)variant).func_177226_a((IProperty)PROPERTY_SNOWY, (Comparable)Boolean.valueOf(snowy));
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta() + ((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY) != false ? PROPERTY_VARIANT.func_177700_c().size() : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, PROPERTY_VARIANT, PROPERTY_SNOWY});
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        return PROPERTY_VARIANT.fromMeta(stack.func_77960_j()).getName();
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess access, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY)).booleanValue()) {
            return Vec3d.field_186680_a;
        }
        return super.func_190949_e(state, access, pos);
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta();
    }

    @Override
    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return state.func_177229_b((IProperty)PROPERTY_VARIANT) != LONG;
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return state.func_177229_b((IProperty)PROPERTY_VARIANT) != LONG;
    }

    @Override
    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == SHORT) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)NORMAL));
        } else if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == NORMAL) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)LONG));
        }
    }

    public static enum Type implements IStringSerializable
    {
        HIGHLANDS("highlands"),
        ENCHANTED("enchanted"),
        ARCTIC("arctic"),
        MAGNETIC("magnetic"),
        IRRADIATED("irradiated"),
        SNOWY("snowy");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

