/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural.plants;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.blocks.natural.BlockAetherGrass;
import com.gildedgames.aether.common.blocks.natural.plants.BlockAetherPlant;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockOrangeTree
extends BlockAetherPlant
implements IGrowable {
    public static final PropertyBool PROPERTY_IS_TOP_BLOCK = PropertyBool.func_177716_a((String)"is_top_block");
    private static final int STAGE_COUNT = 5;
    public static final PropertyInteger PROPERTY_STAGE = PropertyInteger.func_177719_a((String)"stage", (int)1, (int)5);

    public BlockOrangeTree() {
        super(Material.field_151585_k);
        this.func_149711_c(1.0f);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_IS_TOP_BLOCK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)PROPERTY_STAGE, (Comparable)Integer.valueOf(1)));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if ((Integer)blockState.func_177229_b((IProperty)PROPERTY_STAGE) >= 5) {
            return 0.0f;
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState soilBlock = world.func_180495_p(pos.func_177977_b());
        if (soilBlock.func_177230_c() == this && ((Boolean)soilBlock.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK)).booleanValue()) {
            return false;
        }
        return this.isSuitableSoilBlock(world, pos, soilBlock);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        BlockPos topBlock = (Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) != false ? pos : pos.func_177984_a();
        BlockPos bottomBlock = (Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) != false ? pos.func_177977_b() : pos;
        IBlockState soilState = world.func_180495_p(bottomBlock.func_177977_b());
        int chance = 10;
        if (soilState.func_177230_c() == BlocksAether.aether_grass && soilState.func_177229_b((IProperty)BlockAetherGrass.PROPERTY_VARIANT) == BlockAetherGrass.ENCHANTED) {
            chance /= 2;
        }
        if (random.nextInt(chance) == 0) {
            this.growTree(world, topBlock, bottomBlock, 1);
        }
    }

    @Override
    public boolean validatePosition(World world, BlockPos pos, IBlockState state) {
        IBlockState adj;
        if ((Integer)state.func_177229_b((IProperty)PROPERTY_STAGE) >= 3 && (adj = world.func_180495_p((Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) != false ? pos.func_177977_b() : pos.func_177984_a())).func_177230_c() != this) {
            return false;
        }
        return super.validatePosition(world, pos, state);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        this.destroyTree(worldIn, pos, state);
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        BlockPos adjPos;
        boolean isRoot = (Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) == false;
        BlockPos blockPos = adjPos = isRoot ? pos.func_177984_a() : pos.func_177977_b();
        if ((Integer)state.func_177229_b((IProperty)PROPERTY_STAGE) == 5) {
            if (player.field_71075_bZ.field_75098_d) {
                this.destroyTree(world, pos, state);
                return true;
            }
            for (ItemStack item : this.getFruitDrops((IBlockAccess)world, pos, state)) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
            }
            IBlockState adjState = world.func_180495_p(adjPos);
            if (adjState.func_177230_c() == this) {
                world.func_175656_a(adjPos, adjState.func_177226_a((IProperty)PROPERTY_STAGE, (Comparable)Integer.valueOf(4)));
            }
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)PROPERTY_STAGE, (Comparable)Integer.valueOf(4)));
            return false;
        }
        this.destroyTree(world, pos, state);
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        int isTop = meta / 5;
        int stage = (meta - 5 * isTop) % 5 + 1;
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_IS_TOP_BLOCK, (Comparable)Boolean.valueOf(isTop > 0)).func_177226_a((IProperty)PROPERTY_STAGE, (Comparable)Integer.valueOf(stage));
    }

    public int func_176201_c(IBlockState state) {
        int top = (Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) != false ? 5 : 0;
        int stage = (Integer)state.func_177229_b((IProperty)PROPERTY_STAGE);
        return top + stage;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_IS_TOP_BLOCK, PROPERTY_STAGE});
    }

    @Override
    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        int stage = (Integer)state.func_177229_b((IProperty)PROPERTY_STAGE);
        return stage < 5;
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int stage = (Integer)state.func_177229_b((IProperty)PROPERTY_STAGE);
        return stage < 5;
    }

    @Override
    public boolean isSuitableSoilBlock(World world, BlockPos pos, IBlockState state) {
        return state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) == false && (Integer)state.func_177229_b((IProperty)PROPERTY_STAGE) >= 3 || super.isSuitableSoilBlock(world, pos, state);
    }

    private ArrayList<ItemStack> getFruitDrops(IBlockAccess world, BlockPos pos, IBlockState state) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        BlockPos bottomBlock = (Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) != false ? pos.func_177977_b() : pos;
        IBlockState soilState = world.func_180495_p(bottomBlock.func_177977_b());
        boolean applyBonus = soilState.func_177230_c() == BlocksAether.aether_grass && soilState.func_177229_b((IProperty)BlockAetherGrass.PROPERTY_VARIANT) == BlockAetherGrass.ENCHANTED;
        int count = rand.nextInt(3) + (applyBonus ? 2 : 1);
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(ItemsAether.orange, count)});
    }

    private void destroyTree(World world, BlockPos pos, IBlockState state) {
        BlockPos adjPos;
        world.func_175698_g(pos);
        BlockPos blockPos = adjPos = (Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) != false ? pos.func_177977_b() : pos.func_177984_a();
        if (world.func_180495_p(adjPos).func_177230_c() == this) {
            world.func_175698_g(adjPos);
        }
    }

    @Override
    protected void invalidateBlock(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p((Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) != false ? pos.func_177977_b() : pos.func_177984_a()).func_177230_c() == this || world.func_175623_d(pos.func_177977_b()) && (Integer)state.func_177229_b((IProperty)PROPERTY_STAGE) <= 2) {
            this.func_176226_b(world, pos, state, 0);
        }
        this.destroyTree(world, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(list, world, pos, state, fortune);
        if ((Integer)state.func_177229_b((IProperty)PROPERTY_STAGE) == 5) {
            list.addAll(this.getFruitDrops(world, pos, state));
        }
    }

    @Override
    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        BlockPos topBlock = (Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) != false ? pos : pos.func_177984_a();
        BlockPos bottomBlock = (Boolean)state.func_177229_b((IProperty)PROPERTY_IS_TOP_BLOCK) != false ? pos.func_177977_b() : pos;
        this.growTree(world, topBlock, bottomBlock, rand.nextInt(3));
    }

    private void growTree(World world, BlockPos topPos, BlockPos bottomPos, int amount) {
        int nextStage;
        IBlockState topState = world.func_180495_p(bottomPos);
        IBlockState bottomState = world.func_180495_p(bottomPos);
        if (topState.func_177230_c() == this && bottomState.func_177230_c() == this && (nextStage = (Integer)topState.func_177229_b((IProperty)PROPERTY_STAGE) + amount) <= 5) {
            if (nextStage >= 3) {
                if (!world.func_175623_d(topPos) && world.func_180495_p(topPos).func_177230_c() != this) {
                    return;
                }
                world.func_175656_a(topPos, topState.func_177226_a((IProperty)PROPERTY_STAGE, (Comparable)Integer.valueOf(nextStage)).func_177226_a((IProperty)PROPERTY_IS_TOP_BLOCK, (Comparable)Boolean.valueOf(true)));
            }
            world.func_175656_a(bottomPos, topState.func_177226_a((IProperty)PROPERTY_STAGE, (Comparable)Integer.valueOf(nextStage)).func_177226_a((IProperty)PROPERTY_IS_TOP_BLOCK, (Comparable)Boolean.valueOf(false)));
        }
    }
}

