/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural.plants;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.blocks.IBlockMultiName;
import com.gildedgames.aether.common.blocks.natural.BlockAetherGrass;
import com.gildedgames.aether.common.blocks.natural.plants.BlockAetherPlant;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBlueberryBush
extends BlockAetherPlant
implements IBlockMultiName,
IGrowable {
    public static final int BERRY_BUSH_STEM = 0;
    public static final int BERRY_BUSH_RIPE = 1;
    public static final PropertyBool PROPERTY_HARVESTABLE = PropertyBool.func_177716_a((String)"harvestable");
    private static final AxisAlignedBB BUSH_AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.8, 0.8);

    public BlockBlueberryBush() {
        super(Material.field_151584_j);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (((Boolean)blockState.func_177229_b((IProperty)PROPERTY_HARVESTABLE)).booleanValue()) {
            return 0.0f;
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (((Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE)).booleanValue()) {
            if (player.field_71075_bZ.field_75098_d) {
                world.func_175698_g(pos);
                return false;
            }
            if (!world.field_72995_K) {
                for (ItemStack item : this.getFruitDrops((IBlockAccess)world, pos, state)) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
                }
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(false)));
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List items = super.getDrops(world, pos, state, fortune);
        items.addAll(this.getFruitDrops(world, pos, state));
        return items;
    }

    private List<ItemStack> getFruitDrops(IBlockAccess world, BlockPos pos, IBlockState state) {
        boolean applyBonus;
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        IBlockState stateUnderneath = world.func_180495_p(pos.func_177977_b());
        boolean bl = applyBonus = stateUnderneath.func_177230_c() == BlocksAether.aether_grass && stateUnderneath.func_177229_b((IProperty)BlockAetherGrass.PROPERTY_VARIANT) == BlockAetherGrass.ENCHANTED;
        int count = (Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE) != false ? rand.nextInt(2) + (applyBonus ? 2 : 1) : 0;
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(ItemsAether.blueberries, count)});
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!((Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE)).booleanValue() && world.func_175699_k(pos) >= 9 && random.nextInt(60) == 0) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(true)));
        }
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE) == false;
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE) == false;
    }

    @Override
    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_HARVESTABLE, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_HARVESTABLE});
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE) != false ? field_185505_j : BUSH_AABB;
    }

    @Override
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)PROPERTY_HARVESTABLE) != false ? field_185505_j : field_185506_k;
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return "stem";
            }
            case 1: {
                return "ripe";
            }
        }
        return "missingno";
    }
}

