/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural.plants;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.common.blocks.IBlockMultiName;
import com.gildedgames.aether.common.blocks.IBlockSnowy;
import com.gildedgames.aether.common.blocks.natural.plants.BlockAetherPlant;
import com.gildedgames.aether.common.blocks.properties.BlockVariant;
import com.gildedgames.aether.common.blocks.properties.PropertyVariant;
import com.gildedgames.aether.common.entities.monsters.EntityAechorPlant;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAetherFlower
extends BlockAetherPlant
implements IBlockMultiName,
IBlockSnowy {
    public static final BlockVariant WHITE_ROSE = new BlockVariant(0, "white_rose");
    public static final BlockVariant PURPLE_FLOWER = new BlockVariant(1, "purple_flower");
    public static final BlockVariant BURSTBLOSSOM = new BlockVariant(2, "burstblossom");
    public static final BlockVariant AECHOR_SPROUT = new BlockVariant(3, "aechor_sprout");
    public static final PropertyVariant PROPERTY_VARIANT = PropertyVariant.create("variant", WHITE_ROSE, PURPLE_FLOWER, BURSTBLOSSOM, AECHOR_SPROUT);

    public BlockAetherFlower() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)WHITE_ROSE).func_177226_a((IProperty)PROPERTY_SNOWY, (Comparable)Boolean.FALSE));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.field_72995_K && this.func_176473_a(worldIn, pos, state, false)) {
            this.func_176474_b(worldIn, rand, pos, state);
        }
        if (worldIn.func_175642_b(EnumSkyBlock.BLOCK, pos) > 11 && ((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY)).booleanValue()) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)PROPERTY_SNOWY, (Comparable)Boolean.FALSE), 2);
        }
    }

    public int func_149750_m(IBlockState state) {
        return this.field_149784_t;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack main = playerIn.func_184614_ca();
        ItemStack offhand = playerIn.func_184592_cb();
        boolean addSnow = false;
        if (!((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY)).booleanValue()) {
            if (main != null && main.func_77973_b() instanceof ItemBlock) {
                if (((ItemBlock)main.func_77973_b()).func_179223_d() instanceof BlockSnow) {
                    addSnow = true;
                    main.func_190918_g(1);
                }
            } else if (offhand != null && offhand.func_77973_b() instanceof ItemBlock && ((ItemBlock)offhand.func_77973_b()).func_179223_d() instanceof BlockSnow) {
                addSnow = true;
                offhand.func_190918_g(1);
            }
        }
        if (addSnow) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)PROPERTY_SNOWY, (Comparable)Boolean.TRUE), 2);
        }
        return addSnow;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY)).booleanValue() && worldIn.func_180495_p(pos.func_177977_b()) != Blocks.field_150350_a.func_176223_P()) {
            worldIn.func_180501_a(pos, BlocksAether.highlands_snow_layer.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BlockVariant variant : PROPERTY_VARIANT.func_177700_c()) {
            list.add((Object)new ItemStack((Block)this, 1, variant.getMeta()));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        boolean snowy = meta >= PROPERTY_VARIANT.func_177700_c().size();
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)PROPERTY_VARIANT.fromMeta(meta - (snowy ? PROPERTY_VARIANT.func_177700_c().size() : 0))).func_177226_a((IProperty)PROPERTY_SNOWY, (Comparable)Boolean.valueOf(snowy));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta() + ((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY) != false ? PROPERTY_VARIANT.func_177700_c().size() : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_VARIANT, PROPERTY_SNOWY});
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess access, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)PROPERTY_SNOWY)).booleanValue()) {
            return Vec3d.field_186680_a;
        }
        return super.func_190949_e(state, access, pos);
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        return PROPERTY_VARIANT.fromMeta(stack.func_77960_j()).getName();
    }

    @Override
    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        BlockVariant variant = (BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT);
        return variant == AECHOR_SPROUT;
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && worldIn.field_73012_v.nextInt(7) == 0) {
            worldIn.func_175655_b(pos, false);
            EntityAechorPlant aechorPlant = new EntityAechorPlant(worldIn);
            aechorPlant.field_70165_t = (float)pos.func_177958_n() + 0.5f;
            aechorPlant.field_70163_u = pos.func_177956_o();
            aechorPlant.field_70161_v = (float)pos.func_177952_p() + 0.5f;
            worldIn.func_72838_d((Entity)aechorPlant);
        }
    }
}

