/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural.leaves;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.client.renderer.particles.ParticleGolden;
import com.gildedgames.aether.client.renderer.particles.ParticleLeaf;
import com.gildedgames.aether.common.blocks.natural.plants.saplings.BlockAetherUniqueSapling;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAetherLeaves
extends BlockLeaves
implements IShearable {
    public static final PropertyBool PROPERTY_DECAYABLE = PropertyBool.func_177716_a((String)"decayable");
    public static final PropertyBool PROPERTY_CHECK_DECAY = PropertyBool.func_177716_a((String)"check_decay");
    private int[] surroundings;

    public BlockAetherLeaves() {
        this.func_149711_c(0.2f);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_DECAYABLE, (Comparable)Boolean.TRUE).func_177226_a((IProperty)PROPERTY_CHECK_DECAY, (Comparable)Boolean.TRUE));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        Object effect;
        double z;
        double y;
        double x;
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa != 0) {
            return;
        }
        if (this == BlocksAether.amberoot_leaves && rand.nextInt(100) > 90) {
            x = (float)pos.func_177958_n() + rand.nextFloat() * 6.0f - 3.0f;
            y = (float)pos.func_177956_o() + rand.nextFloat() * 6.0f - 3.0f;
            z = (float)pos.func_177952_p() + rand.nextFloat() * 6.0f - 3.0f;
            effect = new ParticleGolden(world, x, y, z, 0.0, 0.0, 0.0);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)effect);
        }
        if (world.func_175623_d(pos.func_177977_b()) && rand.nextInt(100) > 97) {
            x = (float)pos.func_177958_n() + rand.nextFloat();
            y = pos.func_177956_o();
            z = (float)pos.func_177952_p() + rand.nextFloat();
            effect = new ParticleLeaf(world, x, y, z, -0.04 + (double)(rand.nextFloat() * 0.08f), -0.05 + (double)(rand.nextFloat() * -0.02f), -0.04 + (double)(rand.nextFloat() * 0.08f), (Block)this);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)effect);
        }
        super.func_180655_c(state, world, pos, rand);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int z;
        int y;
        boolean start = true;
        int size = 2;
        int x = pos.func_177958_n();
        if (worldIn.func_175707_a(new BlockPos(x - 2, (y = pos.func_177956_o()) - 2, (z = pos.func_177952_p()) - 2), new BlockPos(x + 2, y + 2, z + 2))) {
            for (int x2 = -1; x2 <= 1; ++x2) {
                for (int y2 = -1; y2 <= 1; ++y2) {
                    for (int z2 = -1; z2 <= 1; ++z2) {
                        BlockPos newPos = pos.func_177982_a(x2, y2, z2);
                        IBlockState newState = worldIn.func_180495_p(newPos);
                        if (!newState.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, newPos)) continue;
                        newState.func_177230_c().beginLeavesDecay(newState, worldIn, newPos);
                    }
                }
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            boolean checkDecay = (Boolean)state.func_177229_b((IProperty)PROPERTY_CHECK_DECAY);
            boolean isDecayable = (Boolean)state.func_177229_b((IProperty)PROPERTY_DECAYABLE);
            if (checkDecay && isDecayable) {
                int x2;
                int start = 4;
                int range = 5;
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                int b1 = 32;
                int i1 = 1024;
                int j1 = 16;
                if (this.surroundings == null) {
                    this.surroundings = new int[32768];
                }
                if (world.func_175707_a(new BlockPos(x - 5, y - 5, z - 5), new BlockPos(x + 5, y + 5, z + 5))) {
                    int i;
                    int z2;
                    int y2;
                    BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos();
                    for (x2 = -4; x2 <= 4; ++x2) {
                        for (y2 = -4; y2 <= 4; ++y2) {
                            for (z2 = -4; z2 <= 4; ++z2) {
                                newPos.func_181079_c(x + x2, y + y2, z + z2);
                                Block block = world.func_180495_p((BlockPos)newPos).func_177230_c();
                                i = (x2 + 16) * 1024 + (y2 + 16) * 32 + z2 + 16;
                                if (!block.canSustainLeaves(state, (IBlockAccess)world, (BlockPos)newPos)) {
                                    if (block.isLeaves(state, (IBlockAccess)world, (BlockPos)newPos)) {
                                        this.surroundings[i] = -2;
                                        continue;
                                    }
                                    this.surroundings[i] = -1;
                                    continue;
                                }
                                this.surroundings[i] = 0;
                            }
                        }
                    }
                    for (x2 = 1; x2 <= 4; ++x2) {
                        for (y2 = -4; y2 <= 4; ++y2) {
                            for (z2 = -4; z2 <= 4; ++z2) {
                                for (int j2 = -4; j2 <= 4; ++j2) {
                                    int i6;
                                    int i5;
                                    int i4;
                                    int i3;
                                    int i2;
                                    if (this.surroundings[(y2 + 16) * 1024 + (z2 + 16) * 32 + j2 + 16] != x2 - 1) continue;
                                    i = (y2 + 16 - 1) * 1024 + (z2 + 16) * 32 + j2 + 16;
                                    if (this.surroundings[i] == -2) {
                                        this.surroundings[i] = x2;
                                    }
                                    if (this.surroundings[i2 = (y2 + 16 + 1) * 1024 + (z2 + 16) * 32 + j2 + 16] == -2) {
                                        this.surroundings[i2] = x2;
                                    }
                                    if (this.surroundings[i3 = (y2 + 16) * 1024 + (z2 + 16 - 1) * 32 + j2 + 16] == -2) {
                                        this.surroundings[i3] = x2;
                                    }
                                    if (this.surroundings[i4 = (y2 + 16) * 1024 + (z2 + 16 + 1) * 32 + j2 + 16] == -2) {
                                        this.surroundings[i4] = x2;
                                    }
                                    if (this.surroundings[i5 = (y2 + 16) * 1024 + (z2 + 16) * 32 + (j2 + 16 - 1)] == -2) {
                                        this.surroundings[i5] = x2;
                                    }
                                    if (this.surroundings[i6 = (y2 + 16) * 1024 + (z2 + 16) * 32 + j2 + 16 + 1] != -2) continue;
                                    this.surroundings[i6] = x2;
                                }
                            }
                        }
                    }
                }
                if ((x2 = this.surroundings[16912]) >= 0) {
                    world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)PROPERTY_CHECK_DECAY, (Comparable)Boolean.valueOf(false)), 4);
                } else {
                    this.destroy(world, pos);
                }
            }
        }
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)PROPERTY_CHECK_DECAY)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)PROPERTY_CHECK_DECAY, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150122_b(boolean fancy) {
        this.field_185686_c = Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    public int func_149745_a(Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    private void destroy(World worldIn, BlockPos pos) {
        this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
        worldIn.func_175698_g(pos);
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(new ItemStack((Block)this));
        return stacks;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Minecraft.func_71410_x().field_71474_y.field_74347_j || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this) && this.superShouldSideBeRendered(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean superShouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(blockAccess, pos);
        switch (side) {
            case DOWN: {
                if (!(axisalignedbb.field_72338_b > 0.0)) break;
                return true;
            }
            case UP: {
                if (!(axisalignedbb.field_72337_e < 1.0)) break;
                return true;
            }
            case NORTH: {
                if (!(axisalignedbb.field_72339_c > 0.0)) break;
                return true;
            }
            case SOUTH: {
                if (!(axisalignedbb.field_72334_f < 1.0)) break;
                return true;
            }
            case WEST: {
                if (!(axisalignedbb.field_72340_a > 0.0)) break;
                return true;
            }
            case EAST: {
                if (!(axisalignedbb.field_72336_d < 1.0)) break;
                return true;
            }
        }
        return !blockAccess.func_180495_p(pos.func_177972_a(side)).doesSideBlockRendering(blockAccess, pos.func_177972_a(side), side.func_176734_d());
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack stack;
        Random rand;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (rand.nextInt(20) == 0 && (stack = this.getSaplingItem()) != null) {
            stacks.add(stack);
        }
        if (rand.nextInt(100) == 0 && (stack = this.getPinecone()) != null) {
            stacks.add(stack);
        }
        return stacks;
    }

    protected ItemStack getPinecone() {
        if (this != BlocksAether.mutant_leaves && this != BlocksAether.mutant_leaves_decorated) {
            return new ItemStack(ItemsAether.skyroot_pinecone, 1);
        }
        return null;
    }

    protected ItemStack getSaplingItem() {
        if (this == BlocksAether.amberoot_leaves) {
            return new ItemStack(BlocksAether.unique_sapling, 1, BlockAetherUniqueSapling.AMBEROOT.getMeta());
        }
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_DECAYABLE, (Comparable)Boolean.valueOf((meta & 4) == 4)).func_177226_a((IProperty)PROPERTY_CHECK_DECAY, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)PROPERTY_DECAYABLE)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)PROPERTY_CHECK_DECAY)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_DECAYABLE, PROPERTY_CHECK_DECAY});
    }
}

