/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.common.blocks.IBlockMultiName;
import com.gildedgames.aether.common.blocks.natural.BlockTheraDirt;
import com.gildedgames.aether.common.blocks.properties.BlockVariant;
import com.gildedgames.aether.common.blocks.properties.PropertyVariant;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTheraGrass
extends BlockGrass
implements IBlockMultiName {
    public static final BlockVariant NORMAL = new BlockVariant(0, "normal");
    public static final PropertyVariant PROPERTY_VARIANT = PropertyVariant.create("variant", NORMAL);
    public static final PropertyBool SNOWY = PropertyBool.func_177716_a((String)"snowy");

    public BlockTheraGrass() {
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.6f);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)NORMAL).func_177226_a((IProperty)SNOWY, (Comparable)Boolean.FALSE));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BlockVariant variant : PROPERTY_VARIANT.func_177700_c()) {
            list.add((Object)new ItemStack((Block)this, 1, variant.getMeta()));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return state.func_177226_a((IProperty)SNOWY, (Comparable)Boolean.valueOf(block == Blocks.field_150433_aE || block == Blocks.field_150431_aC));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && state.func_177229_b((IProperty)PROPERTY_VARIANT) == NORMAL) {
            if (world.func_175671_l(pos.func_177984_a()) < 4 && world.func_180495_p(pos.func_177984_a()).getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) {
                world.func_175656_a(pos, BlocksAether.thera_dirt.func_176223_P());
            } else if (world.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos randomNeighbor = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (randomNeighbor.func_177956_o() >= 0 && randomNeighbor.func_177956_o() < 256 && !world.func_175667_e(randomNeighbor)) {
                        return;
                    }
                    IBlockState aboveState = world.func_180495_p(randomNeighbor.func_177984_a());
                    IBlockState neighborState = world.func_180495_p(randomNeighbor);
                    if (neighborState.func_177230_c() != BlocksAether.thera_dirt || neighborState.func_177229_b((IProperty)BlockTheraDirt.PROPERTY_VARIANT) != BlockTheraDirt.DIRT || world.func_175671_l(randomNeighbor.func_177984_a()) < 4 || aboveState.getLightOpacity((IBlockAccess)world, randomNeighbor.func_177984_a()) > 2) continue;
                    IBlockState grassState = this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)NORMAL);
                    world.func_175656_a(randomNeighbor, grassState);
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlocksAether.thera_dirt);
    }

    public IBlockState func_176203_a(int meta) {
        BlockVariant variant = PROPERTY_VARIANT.fromMeta(meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)variant);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta());
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SNOWY, PROPERTY_VARIANT});
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        return PROPERTY_VARIANT.fromMeta(stack.func_77960_j()).getName();
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }
}

