/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural;

import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.blocks.IInternalBlock;
import com.gildedgames.aether.common.entities.animals.EntityMoa;
import com.gildedgames.aether.common.entities.genes.moa.MoaGenePool;
import com.gildedgames.aether.common.entities.genes.moa.MoaNest;
import com.gildedgames.aether.common.entities.tiles.TileEntityMoaEgg;
import com.gildedgames.aether.common.entities.util.groups.EntityGroup;
import com.gildedgames.aether.common.items.other.ItemMoaEgg;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMoaEgg
extends BlockContainer
implements IInternalBlock {
    public static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 0.75, (double)0.8f);

    public BlockMoaEgg() {
        super(Material.field_151578_c);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(0.1f);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityMoaEgg) {
            TileEntityMoaEgg moaEgg = (TileEntityMoaEgg)te;
            moaEgg.familyNest = new MoaNest(world, pos.func_177982_a(0, -1, 0));
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntityMoaEgg egg;
        if (!player.field_71075_bZ.field_75098_d && (egg = (TileEntityMoaEgg)world.func_175625_s(pos)) != null) {
            EntityGroup pack = egg.familyNest.getAnimalPack();
            pack.addOrRenewAggressor((EntityLivingBase)player);
            List moas = world.func_72872_a(EntityMoa.class, new AxisAlignedBB((double)(pos.func_177958_n() - 12), (double)(pos.func_177956_o() - 8), (double)(pos.func_177952_p() - 12), (double)(pos.func_177958_n() + 12), (double)(pos.func_177956_o() + 8), (double)(pos.func_177952_p() + 12)));
            for (Object moa : moas) {
                EntityMoa moa1 = (EntityMoa)moa;
                if (moa1.getGroup().getID() != pack.getID()) continue;
                moa1.setEggStolen(true);
            }
            ItemStack eggStack = new ItemStack(ItemsAether.moa_egg_item, 1, 0);
            MoaGenePool stackGenes = ItemMoaEgg.getGenePool(eggStack);
            stackGenes.transformFromParents(egg.getGenePool().getStorage().getSeed(), egg.getGenePool().getStorage().getFatherSeed(), egg.getGenePool().getStorage().getMotherSeed());
            ItemMoaEgg.setGenePool(eggStack, stackGenes);
            world.func_175698_g(pos);
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)eggStack);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_180649_a(world, pos, player);
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMoaEgg();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack eggStack = new ItemStack(ItemsAether.moa_egg_item);
        TileEntityMoaEgg egg = (TileEntityMoaEgg)world.func_175625_s(pos);
        if (egg != null) {
            MoaGenePool teGenes = egg.getGenePool();
            MoaGenePool stackGenes = ItemMoaEgg.getGenePool(eggStack);
            stackGenes.transformFromParents(teGenes.getStorage().getSeed(), teGenes.getStorage().getFatherSeed(), teGenes.getStorage().getMotherSeed());
            ItemMoaEgg.setGenePool(eggStack, stackGenes);
        }
        return eggStack;
    }
}

