/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural;

import com.gildedgames.aether.common.blocks.IBlockMultiName;
import com.gildedgames.aether.common.blocks.properties.BlockVariant;
import com.gildedgames.aether.common.blocks.properties.PropertyVariant;
import com.gildedgames.aether.common.blocks.util.BlockBuilder;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIceCrystal
extends BlockBuilder
implements IBlockMultiName {
    public static final int CRYSTAL_META = 0;
    public static final int CRYSTAL_A_META = 1;
    public static final int CRYSTAL_B_META = 2;
    public static final BlockVariant STALAGMITE = new BlockVariant(0, "stalagmite");
    public static final BlockVariant STALAGMITE_A = new BlockVariant(1, "stalagmite_a");
    public static final BlockVariant STALAGMITE_B = new BlockVariant(2, "stalagmite_b");
    public static final BlockVariant STALACTITE = new BlockVariant(3, "stalactite");
    public static final BlockVariant STALACTITE_A = new BlockVariant(4, "stalactite_a");
    public static final BlockVariant STALACTITE_B = new BlockVariant(5, "stalactite_b");
    public static final PropertyVariant PROPERTY_VARIANT = PropertyVariant.create("variant", STALAGMITE, STALAGMITE_A, STALAGMITE_B, STALACTITE, STALACTITE_A, STALACTITE_B);
    private static final AxisAlignedBB STALACTITE_BB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB STALACTITE_SHORT_BB = new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB STALAGMITE_BB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB STALAGMITE_SHORT_BB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);

    public BlockIceCrystal() {
        super(Material.field_151592_s);
        this.setSoundType(SoundType.field_185853_f);
        this.func_149711_c(0.25f);
        this.func_149752_b(1.0f);
        this.func_149675_a(true);
    }

    public int func_180651_a(IBlockState state) {
        return STALAGMITE.getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        BlockVariant variant = PROPERTY_VARIANT.fromMeta(meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)variant);
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_VARIANT});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_175642_b(EnumSkyBlock.BLOCK, pos) > 11 - this.func_176223_P().getLightOpacity((IBlockAccess)worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof EntityPlayer) {
            worldIn.func_180495_p(pos).func_177230_c().removedByPlayer(worldIn.func_180495_p(pos), worldIn, pos, (EntityPlayer)entityIn, false);
            if (entityIn.field_70170_p.field_72995_K) {
                entityIn.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.0f);
                for (int i = 0; i < 50; ++i) {
                    double x = (double)pos.func_177958_n() + worldIn.field_73012_v.nextDouble();
                    double y = (double)pos.func_177956_o() + 1.0;
                    double z = (double)pos.func_177952_p() + worldIn.field_73012_v.nextDouble();
                    worldIn.func_175688_a(EnumParticleTypes.WATER_SPLASH, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184812_l_()) {
            worldIn.func_175656_a(pos, state.func_177231_a((IProperty)PROPERTY_VARIANT));
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!(state.func_177229_b((IProperty)PROPERTY_VARIANT) != STALACTITE && state.func_177229_b((IProperty)PROPERTY_VARIANT) != STALACTITE_A && state.func_177229_b((IProperty)PROPERTY_VARIANT) != STALACTITE_B || !worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150355_j)) {
            worldIn.func_175698_g(pos);
        }
        if (!(state.func_177229_b((IProperty)PROPERTY_VARIANT) != STALAGMITE && state.func_177229_b((IProperty)PROPERTY_VARIANT) != STALAGMITE_A && state.func_177229_b((IProperty)PROPERTY_VARIANT) != STALAGMITE_B || !worldIn.func_175623_d(pos.func_177977_b()) && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150355_j)) {
            worldIn.func_175698_g(pos);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (hitY == 0.0f) {
            return this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)PROPERTY_VARIANT.fromMeta(meta + 3));
        }
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)PROPERTY_VARIANT.fromMeta(meta));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int meta = ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta();
        if (meta == STALAGMITE.getMeta() || meta == STALAGMITE_A.getMeta() || meta == STALAGMITE_B.getMeta()) {
            if (meta == STALAGMITE_B.getMeta()) {
                return STALAGMITE_SHORT_BB;
            }
            return STALAGMITE_BB;
        }
        if (meta == STALACTITE_B.getMeta()) {
            return STALACTITE_SHORT_BB;
        }
        return STALACTITE_BB;
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        return PROPERTY_VARIANT.fromMeta(0).getName();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    protected boolean func_149700_E() {
        return true;
    }
}

