/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.common.blocks.IBlockMultiName;
import com.gildedgames.aether.common.blocks.natural.BlockAetherDirt;
import com.gildedgames.aether.common.blocks.natural.plants.BlockAetherFlower;
import com.gildedgames.aether.common.blocks.natural.plants.BlockTallAetherGrass;
import com.gildedgames.aether.common.blocks.properties.BlockVariant;
import com.gildedgames.aether.common.blocks.properties.PropertyVariant;
import com.gildedgames.aether.common.world.biomes.forgotten_highlands.BiomeForgottenHighlands;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAetherGrass
extends Block
implements IBlockMultiName,
IGrowable {
    public static final BlockVariant AETHER = new BlockVariant(0, "normal");
    public static final BlockVariant ENCHANTED = new BlockVariant(1, "enchanted");
    public static final BlockVariant ARCTIC = new BlockVariant(2, "arctic");
    public static final BlockVariant MAGNETIC = new BlockVariant(3, "magnetic");
    public static final BlockVariant IRRADIATED = new BlockVariant(4, "irradiated");
    public static final PropertyVariant PROPERTY_VARIANT = PropertyVariant.create("variant", AETHER, ENCHANTED, ARCTIC, MAGNETIC, IRRADIATED);
    public static final PropertyBool SNOWY = PropertyBool.func_177716_a((String)"snowy");
    private List<FlowerEntry> aetherFlowers = new ArrayList<FlowerEntry>();

    public BlockAetherGrass() {
        super(Material.field_151577_b);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.6f);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)AETHER).func_177226_a((IProperty)SNOWY, (Comparable)Boolean.FALSE));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BlockVariant variant : PROPERTY_VARIANT.func_177700_c()) {
            list.add((Object)new ItemStack((Block)this, 1, variant.getMeta()));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState up = worldIn.func_180495_p(pos.func_177984_a());
        Block block = up.func_177230_c();
        Comparable snowGrass = (Comparable)up.func_177228_b().get(BlockTallAetherGrass.TYPE);
        Comparable snowFlower = (Comparable)up.func_177228_b().get((Object)BlockAetherFlower.PROPERTY_SNOWY);
        return state.func_177226_a((IProperty)SNOWY, (Comparable)Boolean.valueOf(block == BlocksAether.highlands_snow || block == BlocksAether.highlands_snow_layer || snowGrass != null && snowGrass.equals((Object)BlockTallAetherGrass.Type.SNOWY) || snowFlower != null && snowFlower.equals(true)));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && state.func_177229_b((IProperty)PROPERTY_VARIANT) != ENCHANTED) {
            BlockPos.PooledMutableBlockPos up = BlockPos.PooledMutableBlockPos.func_185346_s();
            up.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
            if (world.func_175671_l((BlockPos)up) < 4 && world.func_180495_p((BlockPos)up).getLightOpacity((IBlockAccess)world, (BlockPos)up) > 2) {
                world.func_175656_a(pos, BlocksAether.aether_dirt.func_176223_P());
            } else if (world.func_175671_l((BlockPos)up) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos randomNeighbor = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (randomNeighbor.func_177956_o() >= 0 && randomNeighbor.func_177956_o() < 256 && !world.func_175667_e(randomNeighbor)) {
                        return;
                    }
                    IBlockState aboveState = world.func_180495_p(randomNeighbor.func_177984_a());
                    IBlockState neighborState = world.func_180495_p(randomNeighbor);
                    if (neighborState.func_177230_c() != BlocksAether.aether_dirt || neighborState.func_177229_b((IProperty)BlockAetherDirt.PROPERTY_VARIANT) != BlockAetherDirt.DIRT || world.func_175671_l(randomNeighbor.func_177984_a()) < 4 || aboveState.getLightOpacity((IBlockAccess)world, randomNeighbor.func_177984_a()) > 2) continue;
                    IBlockState grassState = this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, state.func_177229_b((IProperty)PROPERTY_VARIANT));
                    world.func_175656_a(randomNeighbor, grassState);
                }
            }
            up.func_185344_t();
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlocksAether.aether_dirt);
    }

    public IBlockState func_176203_a(int meta) {
        BlockVariant variant = PROPERTY_VARIANT.fromMeta(meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)variant);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta());
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SNOWY, PROPERTY_VARIANT});
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        return PROPERTY_VARIANT.fromMeta(stack.func_77960_j()).getName();
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        block0: for (int count = 0; count < 128; ++count) {
            BlockPos nextPos = pos.func_177984_a();
            for (int grassCount = 0; grassCount < count / 16; ++grassCount) {
                if (worldIn.func_180495_p((nextPos = nextPos.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != BlocksAether.aether_grass || worldIn.func_180495_p(nextPos).func_185915_l()) continue block0;
            }
            if (!worldIn.func_175623_d(nextPos)) continue;
            if (rand.nextInt(8) == 0) {
                this.flowersForGrass(worldIn, state, pos);
                this.plantFlower(worldIn, rand, nextPos);
                this.clearFlower();
                continue;
            }
            int grassHeight = rand.nextInt(3);
            IBlockState nextState1 = grassHeight == 0 ? BlocksAether.tall_aether_grass.func_176203_a(0) : (grassHeight == 1 ? BlocksAether.tall_aether_grass.func_176203_a(1) : BlocksAether.tall_aether_grass.func_176203_a(2));
            IBlockState nextState2 = BlocksAether.tall_aether_grass.func_176223_P();
            if (!BlocksAether.tall_aether_grass.func_176196_c(worldIn, nextPos)) continue;
            if (worldIn.func_180494_b(pos) instanceof BiomeForgottenHighlands && state.func_177229_b((IProperty)PROPERTY_VARIANT) == AETHER) {
                worldIn.func_180501_a(nextPos, nextState1, 3);
                continue;
            }
            worldIn.func_180501_a(nextPos, nextState2, 3);
        }
    }

    private void addFlower(IBlockState state, int weight) {
        this.aetherFlowers.add(new FlowerEntry(state, weight));
    }

    private void plantFlower(World world, Random rand, BlockPos pos) {
        if (this.aetherFlowers.isEmpty()) {
            return;
        }
        FlowerEntry flower = (FlowerEntry)WeightedRandom.func_76271_a((Random)rand, this.aetherFlowers);
        if (flower.state == null) {
            return;
        }
        world.func_180501_a(pos, flower.state, 3);
    }

    private void clearFlower() {
        this.aetherFlowers.clear();
    }

    private void flowersForGrass(World world, IBlockState state, BlockPos pos) {
        this.defaultGrassFlowers();
        this.defaultBiomeFlowers(world, state, pos);
    }

    private void defaultGrassFlowers() {
        this.addFlower(BlocksAether.aether_flower.func_176223_P().func_177226_a((IProperty)BlockAetherFlower.PROPERTY_VARIANT, (Comparable)BlockAetherFlower.PURPLE_FLOWER), 15);
        this.addFlower(BlocksAether.aether_flower.func_176223_P().func_177226_a((IProperty)BlockAetherFlower.PROPERTY_VARIANT, (Comparable)BlockAetherFlower.WHITE_ROSE), 15);
        this.addFlower(BlocksAether.aether_flower.func_176223_P().func_177226_a((IProperty)BlockAetherFlower.PROPERTY_VARIANT, (Comparable)BlockAetherFlower.BURSTBLOSSOM), 15);
        this.addFlower(BlocksAether.neverbloom.func_176223_P(), 10);
        this.addFlower(BlocksAether.quickshoot.func_176223_P(), 10);
        this.addFlower(BlocksAether.pink_swingtip.func_176223_P(), 10);
        this.addFlower(BlocksAether.green_swingtip.func_176223_P(), 10);
        this.addFlower(BlocksAether.blue_swingtip.func_176223_P(), 10);
    }

    private void defaultBiomeFlowers(World world, IBlockState state, BlockPos pos) {
        if (!world.field_72995_K) {
            if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == ARCTIC) {
                this.addFlower(BlocksAether.arctic_spikespring.func_176223_P(), 12);
            } else if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == IRRADIATED) {
                this.addFlower(BlocksAether.irradiated_flower.func_176223_P(), 12);
            } else if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == AETHER) {
                if (world.func_180494_b(pos) instanceof BiomeForgottenHighlands) {
                    this.addFlower(BlocksAether.forgotten_rose.func_176223_P(), 12);
                } else {
                    this.addFlower(BlocksAether.highlands_tulips.func_176223_P(), 12);
                }
            }
        }
    }

    public static class FlowerEntry
    extends WeightedRandom.Item {
        public final IBlockState state;

        FlowerEntry(IBlockState state, int weight) {
            super(weight);
            this.state = state;
        }
    }
}

