/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.natural;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.blocks.IBlockMultiName;
import com.gildedgames.aether.common.blocks.properties.BlockVariant;
import com.gildedgames.aether.common.blocks.properties.PropertyVariant;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAercloud
extends Block
implements IBlockMultiName {
    public static final BlockVariant COLD_AERCLOUD = new BlockVariant(0, "cold");
    public static final BlockVariant BLUE_AERCLOUD = new BlockVariant(1, "blue");
    public static final BlockVariant GREEN_AERCLOUD = new BlockVariant(2, "green");
    public static final BlockVariant GOLDEN_AERCLOUD = new BlockVariant(3, "golden");
    public static final BlockVariant STORM_AERCLOUD = new BlockVariant(4, "storm");
    public static final BlockVariant PURPLE_AERCLOUD = new BlockVariant(5, "purple");
    public static final PropertyVariant PROPERTY_VARIANT = PropertyVariant.create("variant", COLD_AERCLOUD, BLUE_AERCLOUD, GREEN_AERCLOUD, GOLDEN_AERCLOUD, STORM_AERCLOUD, PURPLE_AERCLOUD);
    public static final PropertyEnum<EnumFacing> PROPERTY_FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    private static final AxisAlignedBB AERCLOUD_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3, 1.0);

    public BlockAercloud() {
        super(Material.field_151580_n);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.2f);
        this.func_149713_g(0);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)COLD_AERCLOUD).func_177226_a(PROPERTY_FACING, (Comparable)EnumFacing.NORTH));
    }

    public static IBlockState getAercloudState(BlockVariant variant) {
        return BlocksAether.aercloud.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)variant);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BlockVariant variant : PROPERTY_VARIANT.func_177700_c()) {
            list.add((Object)new ItemStack((Block)this, 1, variant.getMeta()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState offsetState = world.func_180495_p(pos.func_177972_a(side));
        Block block = offsetState.func_177230_c();
        if (block == this && state.func_177229_b((IProperty)PROPERTY_VARIANT) != offsetState.func_177229_b((IProperty)PROPERTY_VARIANT)) {
            return true;
        }
        return block != this && super.func_176225_a(state, world, pos, side);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.field_70143_R = 0.0f;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        entity.field_70143_R = 0.0f;
        boolean canCollide = !entity.func_70093_af() && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75100_b);
        BlockVariant variant = (BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT);
        if (!canCollide || variant == COLD_AERCLOUD || variant == STORM_AERCLOUD) {
            if (entity.field_70181_x < 0.0) {
                entity.field_70181_x *= 0.005;
            }
        } else if (variant == BLUE_AERCLOUD) {
            if (entity.field_70170_p.field_72995_K) {
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundsAether.aercloud_bounce, SoundCategory.BLOCKS, 0.8f, 0.9f + world.field_73012_v.nextFloat() * 0.2f, false);
                for (int i = 0; i < 50; ++i) {
                    double x = (double)pos.func_177958_n() + world.field_73012_v.nextDouble();
                    double y = (double)pos.func_177956_o() + 1.0;
                    double z = (double)pos.func_177952_p() + world.field_73012_v.nextDouble();
                    world.func_175688_a(EnumParticleTypes.WATER_SPLASH, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            entity.field_70181_x = 1.2;
        } else if (variant == GREEN_AERCLOUD || variant == PURPLE_AERCLOUD) {
            EnumFacing facing = variant == GREEN_AERCLOUD ? EnumFacing.func_176741_a((Random)world.field_73012_v) : (EnumFacing)state.func_177229_b(PROPERTY_FACING);
            entity.field_70159_w = (double)facing.func_82601_c() * 2.5;
            entity.field_70179_y = (double)facing.func_82599_e() * 2.5;
        } else if (variant == GOLDEN_AERCLOUD) {
            entity.field_70181_x = -1.2;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == PURPLE_AERCLOUD) {
            float x = (float)pos.func_177958_n() + rand.nextFloat() * 0.7f + 0.15f;
            float y = (float)pos.func_177956_o() + rand.nextFloat() * 0.7f + 0.15f;
            float z = (float)pos.func_177952_p() + rand.nextFloat() * 0.7f + 0.15f;
            EnumFacing facing = (EnumFacing)state.func_177229_b(PROPERTY_FACING);
            float motionX = (float)facing.func_82601_c() * (rand.nextFloat() * 0.01f + 0.05f);
            float motionZ = (float)facing.func_82599_e() * (rand.nextFloat() * 0.01f + 0.05f);
            world.func_175688_a(EnumParticleTypes.CLOUD, (double)x, (double)y, (double)z, (double)motionX, 0.0, (double)motionZ, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockVariant variant = (BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT);
        if (variant == COLD_AERCLOUD || variant == STORM_AERCLOUD) {
            return AERCLOUD_AABB;
        }
        return Block.field_185506_k;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= PURPLE_AERCLOUD.getMeta()) {
            return this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)PURPLE_AERCLOUD).func_177226_a(PROPERTY_FACING, (Comparable)EnumFacing.func_176731_b((int)(meta - PURPLE_AERCLOUD.getMeta())));
        }
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_VARIANT, (Comparable)PROPERTY_VARIANT.fromMeta(meta));
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177229_b((IProperty)PROPERTY_VARIANT) == PURPLE_AERCLOUD) {
            return PURPLE_AERCLOUD.getMeta() + ((EnumFacing)state.func_177229_b(PROPERTY_FACING)).func_176736_b();
        }
        return ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockVariant)state.func_177229_b((IProperty)PROPERTY_VARIANT)).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_VARIANT, PROPERTY_FACING});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a(PROPERTY_FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        return PROPERTY_VARIANT.fromMeta(stack.func_77960_j()).getName();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

