/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.containers;

import com.gildedgames.aether.common.entities.tiles.TileEntitySkyrootChest;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

public class BlockSkyrootChest
extends BlockChest {
    private static final BlockChest.Type TYPE = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"AETHER_SKYROOT", (Class[])new Class[0], (Object[])new Object[0]);

    public BlockSkyrootChest() {
        super(TYPE);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public ILockableContainer func_189418_a(World worldIn, BlockPos pos, boolean isPlayer) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntitySkyrootChest) {
            ILockableContainer container = (ILockableContainer)tileentity;
            if (!this.isBlocked(worldIn, pos)) {
                for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                    BlockPos adjPos = pos.func_177972_a(facing);
                    Block adjBlock = worldIn.func_180495_p(adjPos).func_177230_c();
                    if (adjBlock != this) continue;
                    if (!isPlayer && this.isBlocked(worldIn, adjPos)) {
                        return null;
                    }
                    TileEntity adjTileEntity = worldIn.func_175625_s(adjPos);
                    if (!(adjTileEntity instanceof TileEntityChest)) continue;
                    if (facing != EnumFacing.WEST && facing != EnumFacing.NORTH) {
                        container = new InventoryLargeChest("container.skyroot_double_chest", container, (ILockableContainer)adjTileEntity);
                        continue;
                    }
                    container = new InventoryLargeChest("container.skyroot_double_chest", (ILockableContainer)adjTileEntity, container);
                }
                return container;
            }
        }
        return null;
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        return this.isBelowSolidBlock(worldIn, pos) || this.isOcelotSittingOnChest(worldIn, pos);
    }

    private boolean isBelowSolidBlock(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN, false);
    }

    private boolean isOcelotSittingOnChest(World worldIn, BlockPos pos) {
        for (EntityOcelot ocelot : worldIn.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            if (!ocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySkyrootChest();
    }
}

