/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.containers;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.blocks.IBlockWithItem;
import com.gildedgames.aether.common.entities.tiles.TileEntityPresent;
import com.gildedgames.aether.common.items.blocks.ItemBlockPresent;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPresent
extends BlockContainer
implements IBlockWithItem {
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB((double)0.15f, 0.0, (double)0.15f, (double)0.85f, (double)0.7f, (double)0.85f);

    public BlockPresent() {
        super(Material.field_151580_n);
        this.func_149711_c(0.4f);
        this.func_149713_g(0);
        this.func_149672_a(SoundType.field_185854_g);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlockPresent) {
            TileEntityPresent tileEntity = (TileEntityPresent)world.func_175625_s(pos);
            tileEntity.setPresentData(ItemBlockPresent.getData(stack));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityPresent) {
                this.destroyAndDropPresent(world, (TileEntityPresent)tileEntity, pos);
                return true;
            }
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            double x2 = (float)pos.func_177958_n() + world.field_73012_v.nextFloat() * 1.1f - 0.05f;
            double y2 = (float)pos.func_177956_o() + world.field_73012_v.nextFloat() * 1.1f - 0.05f;
            double z2 = (float)pos.func_177952_p() + world.field_73012_v.nextFloat() * 1.1f - 0.05f;
            world.func_175688_a(EnumParticleTypes.CLOUD, x2, y2, z2, 0.0, 0.0, 0.0, new int[0]);
        }
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundsAether.present_unwrap, SoundCategory.NEUTRAL, 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.5f, false);
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            this.destroyPresent(world, pos);
        }
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    private void destroyAndDropPresent(World world, TileEntityPresent tileEntity, BlockPos pos) {
        tileEntity.dropItem();
        ItemStack drop = new ItemStack(Items.field_151121_aF, 1);
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
        world.func_175713_t(pos);
        world.func_175698_g(pos);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
    }

    private void destroyPresent(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityPresent)) {
            return;
        }
        ItemBlockPresent.PresentData data = ((TileEntityPresent)tileEntity).getPresentData();
        ItemStack present = new ItemStack(BlocksAether.present);
        present.func_77982_d(new NBTTagCompound());
        data.writeToNBT(present.func_77978_p());
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)present);
        world.func_175713_t(pos);
        world.func_175698_g(pos);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.destroyPresent(world, pos);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosionIn) {
        world.func_175713_t(pos);
        world.func_175698_g(pos);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPresent();
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockPresent((Block)this);
    }
}

