/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.containers;

import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.entities.tiles.TileEntityIncubator;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIncubator
extends BlockContainer {
    public static final PropertyBool PROPERTY_IS_LIT = PropertyBool.func_177716_a((String)"is_lit");
    public static final PropertyDirection PROPERTY_FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final int UNLIT_META = 0;
    public static final int LIT_META = 1;
    protected static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8, 1.0);

    public BlockIncubator() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149752_b(17.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_IS_LIT, (Comparable)Boolean.FALSE).func_177226_a((IProperty)PROPERTY_FACING, (Comparable)EnumFacing.NORTH));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityIncubator) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BOUNDS;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)AetherCore.INSTANCE, 7, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)PROPERTY_IS_LIT) != false ? 13 : 0;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTY_FACING, (Comparable)placer.func_174811_aO()));
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityIncubator) {
            ((TileEntityIncubator)tileentity).setCustomInventoryName(stack.func_82833_r());
        }
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)PROPERTY_FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)PROPERTY_IS_LIT)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        boolean isLit = (meta & 8) == 8;
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)PROPERTY_IS_LIT, (Comparable)Boolean.valueOf(isLit));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_IS_LIT, PROPERTY_FACING});
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityIncubator();
    }
}

