/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.containers;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.entities.tiles.TileEntityAltar;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAltar
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection PROPERTY_FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockAltar() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149752_b(17.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_FACING, (Comparable)EnumFacing.NORTH));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityAltar altar = (TileEntityAltar)world.func_175625_s(pos);
        altar.dropContents();
        super.func_180663_b(world, pos, state);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_FACING, (Comparable)placer.func_174811_aO());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PROPERTY_FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)PROPERTY_FACING)).func_176745_a();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityAltar altar = (TileEntityAltar)world.func_175625_s(pos);
            ItemStack heldStack = player.field_71071_by.func_70448_g();
            if (heldStack.func_190926_b() || heldStack.func_77969_a(altar.getStackOnAltar())) {
                this.dropNextItem(altar, world);
            } else if (heldStack.func_77973_b() == ItemsAether.ambrosium_shard) {
                if (altar.getAmbrosiumCount() < 16) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldStack.func_190918_g(1);
                    }
                    altar.addAmbrosiumShard();
                }
            } else if (AetherAPI.content().altar().getMatchingRecipeFromInput(heldStack) != null) {
                ItemStack stack = heldStack.func_77946_l();
                stack.func_190920_e(1);
                if (!altar.getStackOnAltar().func_190926_b()) {
                    world.func_72838_d((Entity)altar.createEntityItemAboveAltar(altar.getStackOnAltar()));
                }
                altar.setStackOnAltar(stack);
                heldStack.func_190918_g(1);
            }
            altar.attemptCrafting();
        }
        return true;
    }

    private void dropNextItem(TileEntityAltar altar, World world) {
        ItemStack stack = null;
        if (!altar.getStackOnAltar().func_190926_b()) {
            stack = altar.getStackOnAltar();
            altar.setStackOnAltar(ItemStack.field_190927_a);
        } else if (altar.getAmbrosiumCount() > 0) {
            stack = new ItemStack(ItemsAether.ambrosium_shard, 1);
            altar.removeAmbrosiumShard();
        }
        if (stack != null) {
            world.func_72838_d((Entity)altar.createEntityItemAboveAltar(stack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAltar();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_FACING});
    }
}

