/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.blocks.construction;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.client.renderer.particles.ParticleAetherPortal;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerSwetTrackerModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerTeleportingModule;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAetherPortal
extends BlockBreakable {
    public static final PropertyEnum<EnumFacing.Axis> PROPERTY_AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    protected static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockAetherPortal() {
        super(Material.field_151567_E, false);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(-1.0f);
        this.func_149715_a(0.75f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PROPERTY_AXIS, (Comparable)EnumFacing.Axis.X));
    }

    public static int getMetaForAxis(EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? 1 : (axis == EnumFacing.Axis.Z ? 2 : 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(PROPERTY_AXIS)) {
            case X: {
                return X_AABB;
            }
            default: {
                return Y_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(150) == 0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundsAether.glowstone_portal_hum, SoundCategory.BLOCKS, 0.2f, rand.nextFloat() * 0.2f + 0.9f, false);
        }
        for (int count = 0; count < 4; ++count) {
            double posX = (float)pos.func_177958_n() + rand.nextFloat();
            double posY = (float)pos.func_177956_o() + rand.nextFloat();
            double posZ = (float)pos.func_177952_p() + rand.nextFloat();
            double motionX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double motionY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double motionZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            int angle = rand.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                posX = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)angle;
                motionX = rand.nextFloat() * 2.0f * (float)angle;
            } else {
                posZ = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)angle;
                motionZ = rand.nextFloat() * 2.0f * (float)angle;
            }
            ParticleAetherPortal effect = new ParticleAetherPortal(world, posX, posY, posZ, motionX, motionY, motionZ);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)effect);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing.Axis axis = null;
        IBlockState state = world.func_180495_p(pos);
        if (world.func_180495_p(pos).func_177230_c() == this) {
            axis = (EnumFacing.Axis)state.func_177229_b(PROPERTY_AXIS);
            if (axis == EnumFacing.Axis.Z && side != EnumFacing.EAST && side != EnumFacing.WEST) {
                return false;
            }
            if (axis == EnumFacing.Axis.X && side != EnumFacing.SOUTH && side != EnumFacing.NORTH) {
                return false;
            }
        }
        boolean westFlag = world.func_180495_p(pos.func_177976_e()).func_177230_c() == this && world.func_180495_p(pos.func_177985_f(2)).func_177230_c() != this;
        boolean eastFlag = world.func_180495_p(pos.func_177974_f()).func_177230_c() == this && world.func_180495_p(pos.func_177965_g(2)).func_177230_c() != this;
        boolean northFlag = world.func_180495_p(pos.func_177978_c()).func_177230_c() == this && world.func_180495_p(pos.func_177964_d(2)).func_177230_c() != this;
        boolean southFlag = world.func_180495_p(pos.func_177968_d()).func_177230_c() == this && world.func_180495_p(pos.func_177970_e(2)).func_177230_c() != this;
        boolean wexFlag = westFlag || eastFlag || axis == EnumFacing.Axis.X;
        boolean nszFlag = northFlag || southFlag || axis == EnumFacing.Axis.Z;
        return wexFlag && side == EnumFacing.WEST || wexFlag && side == EnumFacing.EAST || nszFlag && side == EnumFacing.NORTH || nszFlag && side == EnumFacing.SOUTH;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityPlayer && !entity.func_184218_aH() && !entity.func_184207_aI() && PlayerAether.getPlayer((EntityPlayer)entity).getModule(PlayerSwetTrackerModule.class).getLatchedSwets().isEmpty()) {
            PlayerAether playerAether = PlayerAether.getPlayer((EntityPlayer)entity);
            playerAether.getModule(PlayerTeleportingModule.class).processTeleporting();
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(PROPERTY_AXIS)) {
                    case X: {
                        return state.func_177226_a(PROPERTY_AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(PROPERTY_AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return BlockAetherPortal.getMetaForAxis((EnumFacing.Axis)state.func_177229_b(PROPERTY_AXIS));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PROPERTY_AXIS, (Comparable)((meta & 3) == 2 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        Size size;
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(PROPERTY_AXIS);
        if (!(axis != EnumFacing.Axis.X && axis != EnumFacing.Axis.Z || (size = new Size(world, pos, axis)).isWithinSizeBounds() && size.portalBlocks >= size.height * size.width)) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_AXIS});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public static class Size {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightSideFacing;
        private final EnumFacing leftSideFacing;
        private BlockPos portalPos;
        private int portalBlocks = 0;
        private int height;
        private int width;

        public Size(World world, BlockPos pos, EnumFacing.Axis axis) {
            this.world = world;
            this.axis = axis;
            if (axis == EnumFacing.Axis.X) {
                this.leftSideFacing = EnumFacing.EAST;
                this.rightSideFacing = EnumFacing.WEST;
            } else {
                this.leftSideFacing = EnumFacing.NORTH;
                this.rightSideFacing = EnumFacing.SOUTH;
            }
            BlockPos offsetPos = pos;
            while (pos.func_177956_o() > offsetPos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isBlockSuitable(world.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int x = this.getWidth(pos, this.leftSideFacing) - 1;
            if (x >= 0) {
                this.portalPos = pos.func_177967_a(this.leftSideFacing, x);
                this.width = this.getWidth(this.portalPos, this.rightSideFacing);
                if (this.width < 2 || this.width > 21) {
                    this.portalPos = null;
                    this.width = 0;
                }
            }
            if (this.portalPos != null) {
                this.height = this.getHeight();
            }
        }

        private int getWidth(BlockPos pos, EnumFacing facing) {
            BlockPos offsetPos;
            int x;
            for (x = 0; x < 22 && this.isBlockSuitable(this.world.func_180495_p(offsetPos = pos.func_177967_a(facing, x))) && this.isBlockValidFrame(this.world.func_180495_p(offsetPos.func_177977_b())); ++x) {
            }
            IBlockState state = this.world.func_180495_p(pos.func_177967_a(facing, x));
            return this.isBlockValidFrame(state) ? x : 0;
        }

        private int getHeight() {
            int x;
            this.height = 0;
            block0: while (this.height < 21) {
                for (x = 0; x < this.width; ++x) {
                    BlockPos blockpos = this.portalPos.func_177967_a(this.rightSideFacing, x).func_177981_b(this.height);
                    IBlockState state = this.world.func_180495_p(blockpos);
                    if (!this.isBlockSuitable(state)) break block0;
                    if (state.func_177230_c() == BlocksAether.aether_portal) {
                        ++this.portalBlocks;
                    }
                    if (x == 0 ? !this.isBlockValidFrame(state = this.world.func_180495_p(blockpos.func_177972_a(this.leftSideFacing))) : x == this.width - 1 && !this.isBlockValidFrame(state = this.world.func_180495_p(blockpos.func_177972_a(this.rightSideFacing)))) break block0;
                }
                ++this.height;
            }
            for (x = 0; x < this.width; ++x) {
                if (this.isBlockValidFrame(this.world.func_180495_p(this.portalPos.func_177967_a(this.rightSideFacing, x).func_177981_b(this.height)))) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.portalPos = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        private boolean isBlockSuitable(IBlockState state) {
            return state.func_185904_a() == Material.field_151579_a || state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == BlocksAether.aether_portal;
        }

        public boolean isWithinSizeBounds() {
            return this.portalPos != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public int getPortalBlocks() {
            return this.portalBlocks;
        }

        private boolean isBlockValidFrame(IBlockState state) {
            return state.func_177230_c() == Blocks.field_150426_aN || state.func_177230_c() == Blocks.field_150371_ca;
        }

        public void createPortal() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.portalPos.func_177967_a(this.rightSideFacing, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), BlocksAether.aether_portal.func_176223_P().func_177226_a(PROPERTY_AXIS, (Comparable)this.axis), 2);
                }
            }
        }

        public boolean isPortalBase(IBlockState state) {
            IBlockState block = null;
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.portalPos.func_177967_a(this.rightSideFacing, i);
                for (int j = 0; j < 1; ++j) {
                    block = this.world.func_180495_p(blockpos.func_177981_b(j - 1));
                }
            }
            return block == state;
        }
    }
}

