/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.analytics;

import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.analytics.GAEnvironment;
import com.gildedgames.aether.common.analytics.GAReporter;
import com.gildedgames.aether.common.analytics.GASecret;
import com.gildedgames.aether.common.analytics.GAStorage;
import com.gildedgames.aether.common.analytics.GAUser;
import com.gildedgames.aether.common.analytics.events.GAEvent;
import com.gildedgames.aether.common.analytics.responses.GAInitResponse;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;

public class GameAnalytics
implements GAReporter {
    private static final String SDK_VERSION = "rest api v2";
    private static final int API_VERSION = 2;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private final Gson gson = new Gson();
    private final HttpClient client = HttpClientBuilder.create().build();
    private final String url;
    private final GASecret secret;
    private final String platform = GAEnvironment.getPlatform();
    private final String device = GAEnvironment.getJavaEnvironment();
    private final String manufacturer = GAEnvironment.getJavaVendor();
    private final String operatingSystem = GAEnvironment.getOperatingSystem();
    private final GAStorage storage = new GAStorage();
    private final Queue<GAEvent> scheduled = new ArrayDeque<GAEvent>();
    private final boolean sandboxed;
    private GAState state = GAState.UNLOADED;
    private ScheduledFuture<?> uploadTask;
    private ScheduledFuture<?> saveTask;
    private long tsOffset = 0L;
    private int consecutiveFailures = 0;

    public GameAnalytics() {
        this.url = "http://sandbox-api.gameanalytics.com/v2/5c6bcb5402204249437fb5a7a80a4959";
        this.secret = new GASecret("16813a12f718bc5c620f56944e1abc3ea13ccbac");
        this.sandboxed = true;
    }

    public GameAnalytics(String key, String secret) {
        this.url = "https://api.gameanalytics.com/v2/" + key;
        this.secret = new GASecret(secret);
        this.sandboxed = false;
    }

    @Override
    public void setup() {
        CompletableFuture.runAsync(() -> {
            GAInitResponse result;
            this.storage.load(this.getLocalFile());
            try {
                JsonObject payload = new JsonObject();
                payload.addProperty("platform", this.platform);
                payload.addProperty("os_version", this.operatingSystem);
                payload.addProperty("sdk_version", SDK_VERSION);
                HttpPost request = this.createRequest("/init", (JsonElement)payload);
                HttpResponse response = this.client.execute((HttpUriRequest)request);
                try (InputStreamReader reader = new InputStreamReader(response.getEntity().getContent());){
                    result = (GAInitResponse)this.gson.fromJson((Reader)reader, GAInitResponse.class);
                }
            }
            catch (JsonParseException | IOException e) {
                AetherCore.LOGGER.error("Failed to contact GameAnalytics server");
                return;
            }
            if (result.enabled) {
                this.consecutiveFailures = 0;
                this.tsOffset = result.serverTimestamp - System.currentTimeMillis() / 1000L;
                this.saveTask = this.scheduler.scheduleAtFixedRate(this::flush, 0L, 120L, TimeUnit.SECONDS);
                this.uploadTask = this.scheduler.scheduleAtFixedRate(this::upload, 0L, 20L, TimeUnit.SECONDS);
                this.setState(GAState.ACTIVE);
            } else {
                this.setState(GAState.INACTIVE);
            }
        }, this.scheduler);
    }

    @Override
    public void disable() {
        this.setState(GAState.DISABLED);
        this.storage.clearQueued();
        this.shutdown();
    }

    @Override
    public void flush() {
        this.processScheduled();
        this.storage.save(this.getLocalFile(), false);
    }

    private void setState(GAState state) {
        AetherCore.LOGGER.info("Setting GameAnalytics state to '{}'", (Object)state.name());
        this.state = state;
    }

    private void shutdown() {
        if (this.state != GAState.ACTIVE) {
            return;
        }
        this.state = GAState.UNLOADED;
        this.uploadTask.cancel(false);
        this.saveTask.cancel(false);
        this.storage.save(this.getLocalFile(), true);
    }

    private HttpPost createRequest(String endpoint, JsonElement payload) throws IOException {
        byte[] upload = this.gzipPayload(payload);
        HttpPost post = new HttpPost(this.url + endpoint);
        post.setHeader("Content-Encoding", "gzip");
        post.setHeader("Content-Type", "application/json");
        post.setHeader("Authorization", this.secret.createHmac(upload));
        post.setEntity((HttpEntity)new ByteArrayEntity(upload));
        return post;
    }

    private byte[] gzipPayload(JsonElement tree) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            try (OutputStreamWriter stream = new OutputStreamWriter(new GZIPOutputStream(output));
                 JsonWriter writer = new JsonWriter((Writer)stream);){
                this.gson.toJson(tree, writer);
            }
            output.flush();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScheduled() {
        Queue<GAEvent> queue = this.scheduled;
        synchronized (queue) {
            while (!this.scheduled.isEmpty()) {
                GAEvent event = this.scheduled.remove();
                JsonObject data = event.serialize();
                data.addProperty("v", (Number)2);
                data.addProperty("sdk_version", SDK_VERSION);
                data.addProperty("user_id", this.getUser().getPersistentId().toString());
                data.addProperty("session_id", this.getUser().getSessionId().toString());
                data.addProperty("session_num", (Number)this.getUser().getSessionCount());
                data.addProperty("device", this.device);
                data.addProperty("manufacturer", this.manufacturer);
                data.addProperty("platform", this.platform);
                data.addProperty("os_version", this.operatingSystem);
                this.storage.queueEvent((JsonElement)data);
            }
        }
    }

    private void upload() {
        Collection<JsonElement> batch = this.storage.drainQueuedEvents(1000);
        if (batch.size() <= 0) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            block18: {
                try {
                    JsonArray array = new JsonArray();
                    batch.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                    HttpPost post = this.createRequest("/events", (JsonElement)array);
                    HttpResponse response = this.client.execute((HttpUriRequest)post);
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        ArrayList<JsonElement> failed = new ArrayList<JsonElement>();
                        try (InputStreamReader reader = new InputStreamReader(response.getEntity().getContent());){
                            JsonArray tree = new JsonParser().parse((Reader)reader).getAsJsonArray();
                            for (JsonElement error : tree) {
                                JsonElement event = error.getAsJsonObject().get("event");
                                failed.add(event);
                            }
                        }
                        AetherCore.LOGGER.warn("GameAnalytics server rejected {} events, dropping", (Object)failed.size());
                    }
                    this.consecutiveFailures = 0;
                }
                catch (JsonParseException | IOException e) {
                    AetherCore.LOGGER.error("Failed to submit GA events", e);
                    for (JsonElement event : batch) {
                        this.storage.queueEvent(event);
                    }
                    ++this.consecutiveFailures;
                    if (this.consecutiveFailures <= 1 || !this.state.isScheduling()) break block18;
                    long delay = Math.min(300L, 60L * (long)this.consecutiveFailures);
                    this.uploadTask.cancel(false);
                    this.uploadTask = this.scheduler.scheduleAtFixedRate(this::upload, delay, 20L, TimeUnit.SECONDS);
                    AetherCore.LOGGER.warn("Entering turtle mode for {} seconds due to network errors whilst uploading GA events", (Object)delay);
                }
            }
        }, this.scheduler);
    }

    private File getLocalFile() {
        return new File(AetherCore.PROXY.getConfigDir(), (this.sandboxed ? "analytics-sandbox" : "analytics") + ".json.gz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(GAEvent event) {
        if (!this.state.canProcessEvents()) {
            return;
        }
        Queue<GAEvent> queue = this.scheduled;
        synchronized (queue) {
            this.scheduled.add(event);
        }
    }

    @Override
    public GAUser getUser() {
        return this.storage.getUser();
    }

    @Override
    public long getEpochTimestamp() {
        return System.currentTimeMillis() / 1000L + this.tsOffset;
    }

    private static enum GAState {
        ACTIVE,
        INACTIVE,
        DISABLED,
        UNLOADED;


        public boolean canProcessEvents() {
            return this == ACTIVE;
        }

        public boolean isScheduling() {
            return this == ACTIVE;
        }
    }
}

