/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.analytics;

import com.gildedgames.aether.common.analytics.GAReporter;
import com.gildedgames.aether.common.analytics.events.GASessionEndEvent;
import com.gildedgames.aether.common.analytics.events.GASessionStartEvent;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.UUID;

public class GAUser {
    @Expose
    @SerializedName(value="persistent_id")
    private final UUID persistentId;
    private final UUID sessionId;
    @Expose
    @SerializedName(value="session_count")
    private int sessionCount;
    private long sessionStart;

    protected GAUser(UUID persistentId, int sessionCount) {
        this.persistentId = persistentId;
        this.sessionCount = sessionCount;
        this.sessionId = UUID.randomUUID();
    }

    protected GAUser() {
        this.persistentId = UUID.randomUUID();
        this.sessionId = UUID.randomUUID();
    }

    public void startSession(GAReporter reporter) {
        this.sessionStart = reporter.getEpochTimestamp();
        ++this.sessionCount;
        reporter.schedule(new GASessionStartEvent());
    }

    public void endSession(GAReporter reporter) {
        long duration = reporter.getEpochTimestamp() - this.sessionStart;
        reporter.schedule(new GASessionEndEvent(duration));
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public UUID getPersistentId() {
        return this.persistentId;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }
}

