/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.analytics;

import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.analytics.GAUser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class GAStorage {
    private static final int MAX_QUEUE_SIZE = 2000;
    private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    private final ReentrantLock latch = new ReentrantLock();
    @Expose
    @SerializedName(value="queue")
    private Queue<JsonElement> queue = new ArrayDeque<JsonElement>();
    @Expose
    @SerializedName(value="user")
    private GAUser user = new GAUser();
    private boolean isDirty = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) {
        Validate.notNull((Object)file, (String)"Path cannot be null", (Object[])new Object[0]);
        if (file.exists()) {
            this.latch.lock();
            try (GZIPInputStream input = new GZIPInputStream(new FileInputStream(file));){
                GAStorage storage;
                try (InputStreamReader reader = new InputStreamReader(input);){
                    storage = (GAStorage)this.gson.fromJson((Reader)reader, GAStorage.class);
                }
                this.user = storage.user;
                this.queue = storage.queue;
            }
            catch (JsonParseException | IOException e) {
                AetherCore.LOGGER.error("Failed to load storage", e);
            }
            finally {
                this.latch.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, boolean force) {
        Validate.notNull((Object)file, (String)"Path cannot be null", (Object[])new Object[0]);
        if (!this.isDirty && !force) {
            return;
        }
        this.latch.lock();
        try (GZIPOutputStream gzipStream = new GZIPOutputStream(new FileOutputStream(file));){
            try (OutputStreamWriter writer = new OutputStreamWriter(gzipStream);){
                this.gson.toJson((Object)this, (Appendable)writer);
            }
            this.isDirty = false;
        }
        catch (JsonParseException | IOException e) {
            AetherCore.LOGGER.error("Failed to save storage", e);
        }
        finally {
            this.latch.unlock();
        }
    }

    public void queueEvent(@Nonnull JsonElement json) {
        Validate.notNull((Object)json, (String)"Event cannot be null", (Object[])new Object[0]);
        this.latch.lock();
        if (this.queue.size() < 2000) {
            this.queue.add(json);
            this.isDirty = true;
        }
        this.latch.unlock();
    }

    public Collection<JsonElement> drainQueuedEvents(int max) {
        this.latch.lock();
        if (this.queue.isEmpty()) {
            this.latch.unlock();
            return Collections.emptyList();
        }
        ArrayList<JsonElement> list = new ArrayList<JsonElement>();
        while (list.size() < max && !this.queue.isEmpty()) {
            list.add(this.queue.remove());
        }
        this.isDirty = true;
        this.latch.unlock();
        return list;
    }

    @Nonnull
    public GAUser getUser() {
        return this.user;
    }

    public void clearQueued() {
        this.latch.lock();
        this.queue.clear();
        this.isDirty = true;
        this.latch.unlock();
    }
}

