/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.analytics;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class GASecret {
    private static final String ALGORITHM = "HmacSHA256";
    private final Mac mac;

    public GASecret(String secret) {
        try {
            SecretKeySpec key = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), ALGORITHM);
            this.mac = Mac.getInstance(ALGORITHM);
            this.mac.init(key);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Couldn't initialize MAC", e);
        }
    }

    public String createHmac(byte[] data) {
        byte[] hmac = this.mac.doFinal(data);
        byte[] base64 = Base64.encodeBase64((byte[])hmac);
        return new String(base64);
    }
}

