/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.analytics;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GAEnvironment {
    public static String getJavaEnvironment() {
        return System.getProperty("java.version");
    }

    public static String getJavaVendor() {
        String name = System.getProperty("java.vendor");
        if (name.length() > 64) {
            return name.substring(0, 63);
        }
        return name;
    }

    public static String getPlatform() {
        String name = System.getProperty("os.name").toLowerCase();
        if (name.startsWith("windows")) {
            return "windows";
        }
        if (name.startsWith("mac")) {
            return "mac_osx";
        }
        return "linux";
    }

    public static String getOperatingSystem() {
        Matcher matcher = Pattern.compile("[0-9]{0,5}(\\.[0-9]{0,5}){0,2}").matcher(System.getProperty("os.version"));
        String version = " ";
        if (matcher.find()) {
            version = version + matcher.group(0);
        }
        return GAEnvironment.getPlatform() + version;
    }
}

