/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="aether")
public class ConfigAether {
    @Config.Ignore
    private static final String LANG_PREFIX = "config.aether.";
    @Config.LangKey(value="config.aether.skip_intro.name")
    @Config.Comment(value={"Skips the Necromancer's Tower introduction sequence when entering the Aether for the first time."})
    public static boolean skipIntro = true;
    @Config.LangKey(value="config.aether.cutout_helmets.name")
    @Config.Comment(value={"Enables the player's skin to be seen through gaps in Aether helmets. Setting to false shows an opaque dark texture instead."})
    public static boolean cutoutHelmets = true;
    @Config.LangKey(value="config.aether.helmet_shadow.name")
    @Config.Comment(value={"Renders a shadow layer ovet the player's skin when transparent helmets are enabled."})
    public static boolean helmetShadow = true;
    @Config.LangKey(value="config.aether.aether_dimension_id.name")
    @Config.Comment(value={"The Dimension ID for the main Aether II dimension, change this value to fix conflicts with other dimensions."})
    @Config.RequiresMcRestart
    public static int aetherDimID = 3;
    @Config.LangKey(value="config.aether.necromancer_dimension_id.name")
    @Config.Comment(value={"The Dimension ID for the introduction sequence for Aether II, change this value to fix conflicts with other dimensions."})
    @Config.RequiresMcRestart
    public static int necromancerDimId = 4;
    @Config.LangKey(value="config.aether.display_performance_indicator.name")
    @Config.Comment(value={"Enables a small UI that shows performance of the internal server, used for debugging."})
    public static boolean displayPerformanceIndicator = false;
    @Config.LangKey(value="config.aether.analytics_enabled.name")
    @Config.Comment(value={"Enables us to collect generic data while you play Aether II, no personal data is recorded."})
    public static boolean analyticsEnabled = true;
    @Config.LangKey(value="config.aether.fingerprint_violation.name")
    @Config.Comment(value={"If the version of the Aether II you are using sets off any flags that it might not be from the official source, a warning will appear when the game launches. Enabling this config disables that warning."})
    public static boolean acknowledgeFingerprintViolation = false;
    @Config.LangKey(value="config.aether.aerwhale_riding.name")
    @Config.Comment(value={"Definitely not a joke."})
    public static boolean rideableAerwhale = false;

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("aether")) {
            ConfigManager.sync((String)"aether", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

