/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.IAetherServices;
import com.gildedgames.aether.api.net.IGildedGamesAccountApi;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.CompatibilityAether;
import com.gildedgames.aether.common.ContentRegistry;
import com.gildedgames.aether.common.events.PostAetherTravelEvent;
import com.gildedgames.aether.common.network.api.GildedGamesAccountApiImpl;
import com.gildedgames.aether.common.shop.ShopBuy;
import com.gildedgames.aether.common.shop.ShopCurrencyGilt;
import com.gildedgames.aether.common.shop.ShopCurrencyPlumproot;
import com.gildedgames.aether.common.shop.ShopInstance;
import com.gildedgames.aether.common.shop.ShopInstanceGroup;
import com.gildedgames.aether.common.shop.ShopInventory;
import com.gildedgames.aether.common.shop.filters.ShopFilterNewYearsEdisonSale;
import com.gildedgames.aether.common.world.biomes.irradiated_forests.IrradiatedForestsData;
import com.gildedgames.aether.common.world.biomes.magnetic_hills.MagneticHillPillar;
import com.gildedgames.aether.common.world.biomes.magnetic_hills.MagneticHillsData;
import com.gildedgames.aether.common.world.instances.necromancer_tower.NecromancerTowerInstance;
import com.gildedgames.aether.common.world.island.IslandVariables;
import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.util.io.IClassSerializer;
import com.gildedgames.orbis.lib.util.io.Instantiator;
import com.gildedgames.orbis.lib.util.io.SimpleSerializer;
import java.io.File;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CommonProxy
implements IAetherServices {
    private final ContentRegistry contentRegistry = new ContentRegistry();
    private final GildedGamesAccountApiImpl webAPI = new GildedGamesAccountApiImpl();
    private File configDir;

    public void preInit(FMLPreInitializationEvent event) {
        CompatibilityAether.locateInstalledMods();
        this.configDir = new File(event.getModConfigurationDirectory(), "Aether/");
        if (!this.configDir.exists() && !this.configDir.mkdir()) {
            throw new RuntimeException("Couldn't create configuration directory");
        }
        SimpleSerializer s = new SimpleSerializer("aether");
        s.register(0, NecromancerTowerInstance.class, (Function)new Instantiator(NecromancerTowerInstance.class));
        s.register(1, MagneticHillsData.class, (Function)new Instantiator(MagneticHillsData.class));
        s.register(2, MagneticHillPillar.class, (Function)new Instantiator(MagneticHillPillar.class));
        s.register(3, IrradiatedForestsData.class, (Function)new Instantiator(IrradiatedForestsData.class));
        s.register(4, IslandVariables.class, (Function)new Instantiator(IslandVariables.class));
        s.register(5, ShopInstance.class, (Function)new Instantiator(ShopInstance.class));
        s.register(6, ShopBuy.class, (Function)new Instantiator(ShopBuy.class));
        s.register(7, ShopInventory.class, (Function)new Instantiator(ShopInventory.class));
        s.register(8, ShopCurrencyGilt.class, (Function)new Instantiator(ShopCurrencyGilt.class));
        s.register(9, ShopCurrencyPlumproot.class, (Function)new Instantiator(ShopCurrencyPlumproot.class));
        s.register(10, ShopInstanceGroup.class, (Function)new Instantiator(ShopInstanceGroup.class));
        OrbisLib.services().io().register((IClassSerializer)s);
        this.contentRegistry.preInit();
        AetherAPI.content().shop().registerGlobalFilter(new ShopFilterNewYearsEdisonSale());
    }

    public void init(FMLInitializationEvent event) {
        this.contentRegistry.init();
        MinecraftForge.EVENT_BUS.register((Object)AetherCore.CONFIG);
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.content().postInit();
    }

    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        this.content().onServerAboutToStart();
    }

    public void onServerStarting(FMLServerStartingEvent event) {
        this.content().onServerStarting();
    }

    public void spawnJumpParticles(World world, double x, double y, double z, double radius, int quantity) {
        Random random = world.field_73012_v;
        for (int i = 0; i < quantity; ++i) {
            double x2 = x + random.nextDouble() * radius - radius * 0.5;
            double y2 = y + random.nextDouble() * 0.4;
            double z2 = z + random.nextDouble() * radius - radius * 0.5;
            world.func_175688_a(EnumParticleTypes.CLOUD, x2, y2, z2, 0.0, random.nextDouble() * 0.03, 0.0, new int[0]);
        }
    }

    public void spawnCampfireStartParticles(World world, double x, double y, double z) {
    }

    public void spawnCampfireParticles(World world, double x, double y, double z) {
    }

    public void spawnSlashParticleFrom(World world, double x, double y, double z, double offsetX, double offsetY, double offsetZ) {
    }

    public void spawnPierceParticleFrom(World world, double x, double y, double z, double offsetX, double offsetY, double offsetZ) {
    }

    public void spawnImpactParticleFrom(World world, double x, double y, double z, double offsetX, double offsetY, double offsetZ) {
    }

    public void spawnEffectParticles(World world, double posXIn, double posYIn, double posZIn, double motionX, double motionY, double motionZ, float particleRed, float particleGreen, float particleBlue) {
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public void displayDismountMessage(EntityPlayer player) {
    }

    public void turnOffScreen() {
    }

    public void modifyEntityQuicksoil(EntityLivingBase entity) {
        entity.field_70159_w *= 1.7;
        entity.field_70179_y *= 1.7;
        double maxMotion = 0.7;
        entity.field_70159_w = MathHelper.func_151237_a((double)entity.field_70159_w, (double)-0.7, (double)0.7);
        entity.field_70179_y = MathHelper.func_151237_a((double)entity.field_70179_y, (double)-0.7, (double)0.7);
    }

    public Entity teleportEntity(Entity entity, WorldServer toWorld, Teleporter teleporter, int dimension, @Nullable Supplier<BlockPos> optionalLoc) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityPlayer) {
            if (!ForgeHooks.onTravelToDimension((Entity)entity, (int)dimension)) {
                return entity;
            }
            if (!toWorld.field_72995_K) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                PlayerList playerList = server.func_184103_al();
                EntityPlayerMP player = (EntityPlayerMP)entity;
                playerList.transferPlayerToDimension(player, dimension, teleporter);
                player.field_71088_bW = player.func_82147_ab();
                if (optionalLoc == null) {
                    player.field_71135_a.func_147364_a(player.field_70165_t + 0.5, player.field_70163_u, player.field_70161_v + 0.5, 0.0f, 0.0f);
                } else {
                    BlockPos loc = optionalLoc.get();
                    player.field_71135_a.func_147364_a((double)loc.func_177958_n() + 0.5, (double)loc.func_177956_o(), (double)loc.func_177952_p() + 0.5, 225.0f, 0.0f);
                }
                player.field_184851_cj = true;
                PostAetherTravelEvent event = new PostAetherTravelEvent(entity);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
            return entity;
        }
        Entity newEntity = entity.func_184204_a(dimension);
        newEntity.field_98038_p = true;
        newEntity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        return newEntity;
    }

    @Override
    public ContentRegistry content() {
        return this.contentRegistry;
    }

    @Override
    public IGildedGamesAccountApi gildedGamesAccountApi() {
        return this.webAPI;
    }

    public IThreadListener getMinecraftThread() {
        return null;
    }
}

