/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.common.CommonProxy;
import com.gildedgames.aether.common.ConfigAether;
import com.gildedgames.aether.common.analytics.GAReporter;
import com.gildedgames.aether.common.util.JarValidator;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="Aether II", modid="aether", version="0.3.0", certificateFingerprint="db341c083b1b8ce9160a769b569ef6737b3f4cdf", dependencies="required-after:orbis-lib@[0.2.0,);required-after:forge@[14.23.5.2816,)", acceptedMinecraftVersions="[1.12.2]")
public class AetherCore {
    public static final String MOD_NAME = "Aether II";
    public static final String MOD_ID = "aether";
    public static final String MOD_VERSION = "0.3.0";
    public static final String MOD_DEPENDENCIES = "required-after:orbis-lib@[0.2.0,);required-after:forge@[14.23.5.2816,)";
    public static final Logger LOGGER = LogManager.getLogger((String)"AetherII");
    public static final String MOD_FINGERPRINT = "db341c083b1b8ce9160a769b569ef6737b3f4cdf";
    @Mod.Instance(value="aether")
    public static AetherCore INSTANCE;
    @SidedProxy(clientSide="com.gildedgames.aether.client.ClientProxy", serverSide="com.gildedgames.aether.common.CommonProxy")
    public static CommonProxy PROXY;
    public static ConfigAether CONFIG;
    public static GAReporter ANALYTICS;
    public static boolean IS_SIGNED;

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static String getResourcePath(String name) {
        return "aether:" + name;
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static boolean isServer() {
        return FMLCommonHandler.instance().getSide().isServer();
    }

    public static boolean isInsideDevEnvironment() {
        return Launch.blackboard.get("fml.deobfuscatedEnvironment") == Boolean.TRUE;
    }

    @Mod.EventHandler
    public void onModConstruction(FMLConstructionEvent event) {
        AetherAPI.registerProvider(PROXY);
    }

    @Mod.EventHandler
    public void onModPreInit(FMLPreInitializationEvent event) {
        CONFIG = new ConfigAether();
        if (!AetherCore.isInsideDevEnvironment() && !JarValidator.validate(event.getSourceFile())) {
            LOGGER.warn("Failed to validate extended properties for the file located at " + event.getSourceFile());
            IS_SIGNED = false;
        }
        PROXY.preInit(event);
    }

    @Mod.EventHandler
    public void onModInit(FMLInitializationEvent event) {
        PROXY.init(event);
    }

    @Mod.EventHandler
    public void onModPostInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        PROXY.onServerAboutToStart(event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        PROXY.onServerStarting(event);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (AetherCore.isInsideDevEnvironment()) {
            LOGGER.warn("Ignoring missing certificate for the Aether II because we are in a de-obfuscated workspace...");
            return;
        }
        IS_SIGNED = false;
        LOGGER.warn("No valid certificates could be found for the file located at: " + event.getSource());
        LOGGER.warn("You have downloaded a release of the Aether II which does not contain a valid code signing certificate. This release will not receive support from Gilded Games.");
    }

    static {
        IS_SIGNED = true;
    }
}

