/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.util;

import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.vector.Quaternion;

public class QuaternionUtil {
    public static final Vec3d Z_AXIS = new Vec3d(0.0, 0.0, 1.0);
    public static final Quaternion Y_IDENTITY = new Quaternion(0.0f, 1.0f, 0.0f, (float)Math.PI);
    public static final Quaternion IDENTITY = new Quaternion();

    public static Quaternion lookAt(Vec3d sourcePoint, Vec3d destPoint) {
        Vec3d forward = destPoint.func_178788_d(sourcePoint).func_72432_b();
        double dot = Z_AXIS.func_72430_b(forward);
        if (Math.abs(dot - -1.0) < (double)1.0E-6f) {
            return Y_IDENTITY;
        }
        if (Math.abs(dot - 1.0) < (double)1.0E-6f) {
            return IDENTITY;
        }
        float rotAngle = (float)Math.acos(dot);
        Vec3d rotAxis = Z_AXIS.func_72431_c(forward);
        rotAxis = rotAxis.func_72432_b();
        float halfAngle = rotAngle * 0.5f;
        float s = (float)Math.sin(halfAngle);
        return new Quaternion((float)rotAxis.field_72450_a * s, (float)rotAxis.field_72448_b * s, (float)rotAxis.field_72449_c * s, (float)Math.cos(halfAngle));
    }

    public static Quaternion interpolateQuaternion(Quaternion a, Quaternion b, float p) {
        Quaternion d = new Quaternion(b.x - a.x, b.y - a.y, b.z - a.z, b.w - a.w);
        Quaternion q = new Quaternion(a.x + d.x * p, a.y + d.y * p, a.z + d.z * p, a.w + d.w * p);
        return q.normalise(q);
    }
}

