/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.sound;

import com.gildedgames.aether.api.player.IPlayerAether;
import com.gildedgames.aether.client.events.listeners.gui.GuiLoadingListener;
import com.gildedgames.aether.client.sound.generators.AetherMusicGenerator;
import com.gildedgames.aether.client.sound.generators.IMusicGenerator;
import com.gildedgames.aether.common.init.DimensionsAether;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class AetherMusicManager {
    public static final AetherMusicManager INSTANCE = new AetherMusicManager();
    private final ArrayList<IMusicGenerator> generators = new ArrayList();
    private ISound currentSong;
    private ISound currentRecord;
    private int quietPeriod;

    public AetherMusicManager() {
        this.addGenerator(new AetherMusicGenerator());
    }

    public void addGenerator(IMusicGenerator generator) {
        this.generators.add(generator);
    }

    public void update(IPlayerAether aePlayer) {
        if (this.canPlayMusic() && !this.isPlayingMusic()) {
            if (this.quietPeriod <= 0) {
                IMusicGenerator generator = this.getNextPlayableSong(aePlayer);
                if (generator == null) {
                    this.quietPeriod += 200;
                } else {
                    SoundEvent event = generator.getMusicResource(aePlayer);
                    if (event == null) {
                        this.quietPeriod += 200;
                        return;
                    }
                    this.playMusic(event);
                    this.quietPeriod = generator.getQuietPeriod(aePlayer);
                }
            }
            --this.quietPeriod;
        }
    }

    private IMusicGenerator getNextPlayableSong(IPlayerAether aePlayer) {
        for (IMusicGenerator generator : this.generators) {
            if (!generator.isPlayable(aePlayer)) continue;
            return generator;
        }
        return null;
    }

    public void playMusic(SoundEvent event) {
        if (this.isPlayingMusic()) {
            this.stopMusic();
        }
        this.currentSong = PositionedSoundRecord.func_184370_a((SoundEvent)event);
        this.getSoundHandler().func_147682_a(this.currentSong);
    }

    public void stopMusic() {
        if (this.currentSong != null) {
            this.getSoundHandler().func_147683_b(this.currentSong);
            this.currentSong = null;
        }
    }

    public void onRecordPlayed(ISound sound) {
        this.currentRecord = sound;
        if (this.isPlayingMusic()) {
            this.stopMusic();
        }
    }

    private boolean isPlayingMusic() {
        return this.currentSong != null && this.getSoundHandler().func_147692_c(this.currentSong);
    }

    private boolean canPlayMusic() {
        return !Minecraft.func_71410_x().func_147113_T() && (this.currentRecord == null || !this.getSoundHandler().func_147692_c(this.currentRecord));
    }

    private SoundHandler getSoundHandler() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlaySound(PlaySoundEvent event) {
        if (GuiLoadingListener.isLoadingScreen()) {
            event.setResultSound(null);
            return;
        }
        if (event.getSound().func_184365_d() == SoundCategory.MUSIC) {
            EntityPlayerSP player;
            if (!(event.getSound().func_147650_b().func_110624_b().equals("aether") || (player = Minecraft.func_71410_x().field_71439_g) == null || player.field_70170_p.field_73011_w.func_186058_p() != DimensionsAether.AETHER && player.field_70170_p.field_73011_w.func_186058_p() != DimensionsAether.NECROMANCER_TOWER)) {
                event.setResultSound(null);
            }
        } else if (event.getSound().func_184365_d() == SoundCategory.RECORDS) {
            INSTANCE.onRecordPlayed(event.getSound());
        }
    }
}

