/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer.world;

import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.world.islands.precipitation.IPrecipitationManager;
import com.gildedgames.aether.client.renderer.textures.SimpleDXT1Texture;
import com.gildedgames.aether.client.renderer.world.EntityRendererHelper;
import com.gildedgames.aether.common.AetherCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.util.glu.Project;

public class RenderWorldSkybox
extends IRenderHandler {
    private static final float TRANSITION_PER_TICK = 0.125f;
    private static final ResourceLocation TEXTURE_SKYBOX = AetherCore.getResource("textures/environment/skybox/skybox_clouds.png");
    private SimpleDXT1Texture texture;
    private long prevUpdateTimeMillis;
    private long nowUpdateTimeMillis;
    private float skyDarkness;

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        if (this.texture == null) {
            this.texture = new SimpleDXT1Texture(TEXTURE_SKYBOX);
            mc.func_110434_K().func_110579_a(TEXTURE_SKYBOX, (ITextureObject)this.texture);
        }
        this.prevUpdateTimeMillis = this.nowUpdateTimeMillis;
        this.nowUpdateTimeMillis = System.nanoTime() / 1000000L;
        this.updateLightmap(mc, partialTicks);
        float farPlaneDistance = mc.field_71474_y.field_151451_c * 32;
        mc.field_71460_t.func_180436_i();
        GlStateManager.func_179106_n();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        Project.gluPerspective((float)this.getFOVModifier(partialTicks, true), (float)((float)mc.field_71443_c / (float)mc.field_71440_d), (float)0.05f, (float)(farPlaneDistance * 4.0f));
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        mc.func_110434_K().func_110577_a(TEXTURE_SKYBOX);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        int k2 = 0xF00000;
        int h = k2 >> 16 & 0xFFFF;
        int k = k2 & 0xFFFF;
        Tessellator tessellator = Tessellator.func_178181_a();
        float f = farPlaneDistance * 4.0f;
        float a = 1.0f;
        float b = 1.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        builder.func_181662_b((double)(-0.5f * f), (double)(-0.5f * f), (double)(0.5f * f)).func_187315_a(0.5, 1.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(-0.5f * f), (double)(0.5f * f)).func_187315_a(0.5, 0.5).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(-0.5f * f), (double)(-0.5f * f)).func_187315_a(0.25, 0.5).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(-0.5f * f), (double)(-0.5f * f)).func_187315_a(0.25, 1.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(0.5f * f), (double)(0.5f * f)).func_187315_a(0.5, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(0.5f * f), (double)(0.5f * f)).func_187315_a(0.5, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(0.5f * f), (double)(-0.5f * f)).func_187315_a(0.25, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(0.5f * f), (double)(-0.5f * f)).func_187315_a(0.25, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(-0.5f * f), (double)(-0.5f * f)).func_187315_a(0.25, 0.5).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(0.5f * f), (double)(-0.5f * f)).func_187315_a(0.25, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(0.5f * f), (double)(-0.5f * f)).func_187315_a(0.0, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(-0.5f * f), (double)(-0.5f * f)).func_187315_a(0.0, 0.5).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(-0.5f * f), (double)(0.5f * f)).func_187315_a(0.75, 0.5).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(0.5f * f), (double)(0.5f * f)).func_187315_a(0.75, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(0.5f * f), (double)(0.5f * f)).func_187315_a(0.5, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(-0.5f * f), (double)(0.5f * f)).func_187315_a(0.5, 0.5).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(-0.5f * f), (double)(-0.5f * f)).func_187315_a(1.0, 0.5).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(0.5f * f), (double)(-0.5f * f)).func_187315_a(1.0, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(0.5f * f), (double)(0.5f * f)).func_187315_a(0.75, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(-0.5f * f), (double)(-0.5f * f), (double)(0.5f * f)).func_187315_a(0.75, 0.5).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(-0.5f * f), (double)(0.5f * f)).func_187315_a(0.5, 0.5).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(0.5f * f), (double)(0.5f * f)).func_187315_a(0.5, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(0.5f * f), (double)(-0.5f * f)).func_187315_a(0.25, 0.0).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        builder.func_181662_b((double)(0.5f * f), (double)(-0.5f * f), (double)(-0.5f * f)).func_187315_a(0.25, 0.5).func_187314_a(h, k).func_181666_a(b, b, b, a).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        Project.gluPerspective((float)this.getFOVModifier(partialTicks, true), (float)((float)mc.field_71443_c / (float)mc.field_71440_d), (float)0.05f, (float)(farPlaneDistance * MathHelper.field_180189_a));
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179106_n();
        mc.field_71460_t.func_175072_h();
    }

    private float getFOVModifier(float partialTicks, boolean useFOVSetting) {
        return Minecraft.func_71410_x().field_71460_t.func_78481_a(partialTicks, useFOVSetting);
    }

    private void updateLightmap(Minecraft mc, float partialTicks) {
        IPrecipitationManager precipitation = (IPrecipitationManager)Minecraft.func_71410_x().field_71441_e.getCapability(CapabilitiesAether.PRECIPITATION_MANAGER, null);
        if (precipitation == null) {
            this.skyDarkness = 0.0f;
            return;
        }
        if (!mc.field_71441_e.func_72896_J()) {
            this.skyDarkness -= this.getUpdateStep() * 0.125f;
            if (this.skyDarkness < 0.0f) {
                this.skyDarkness = 0.0f;
            }
        } else {
            float target = precipitation.getSkyDarkness();
            if (target > this.skyDarkness) {
                this.skyDarkness += this.getUpdateStep() * 0.125f;
                if (this.skyDarkness > target) {
                    this.skyDarkness = target;
                }
            } else {
                this.skyDarkness -= this.getUpdateStep() * 0.125f;
                if (this.skyDarkness < target) {
                    this.skyDarkness = target;
                }
            }
        }
        float strength = 1.0f - this.skyDarkness;
        float f = mc.field_71441_e.func_72971_b(partialTicks);
        EntityRendererHelper.updateLightmap(mc, partialTicks, f *= strength);
    }

    private float getUpdateStep() {
        return (float)(this.nowUpdateTimeMillis - this.prevUpdateTimeMillis) / 1000.0f;
    }
}

