/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer.world;

import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.api.world.islands.precipitation.IPrecipitationManager;
import com.gildedgames.aether.api.world.islands.precipitation.PrecipitationStrength;
import com.gildedgames.aether.common.AetherCore;
import java.util.HashMap;
import java.util.Random;
import javax.vecmath.Vector2f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.IRenderHandler;

public class RenderWorldPrecipitation
extends IRenderHandler {
    private final HashMap<String, ResourceLocation> textureCache = new HashMap();
    private int renderTicks;
    private int renderTicksSinceSound;
    private final float[] rainXCoords = new float[1024];
    private final float[] rainYCoords = new float[1024];
    private final Random random = new Random();
    private float skyDarkness;
    private float lastSkyDarkness;

    public RenderWorldPrecipitation() {
        for (int x = 0; x < 32; ++x) {
            for (int y = 0; y < 32; ++y) {
                float y2 = y - 16;
                float x2 = x - 16;
                float f2 = MathHelper.func_76129_c((float)(y2 * y2 + x2 * x2));
                this.rainXCoords[x << 5 | y] = -x2 / f2;
                this.rainYCoords[x << 5 | y] = y2 / f2;
            }
        }
    }

    public void tick() {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            ++this.renderTicks;
            ++this.renderTicksSinceSound;
        }
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        this.playSounds(mc);
        mc.field_71460_t.func_180436_i();
        Entity entity = mc.func_175606_aa();
        int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int entityZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        int l = MathHelper.func_76128_c((double)y);
        int radius = 5;
        if (mc.field_71474_y.field_74347_j) {
            radius = 10;
        }
        int continuous = -1;
        buffer.func_178969_c(-x, -y, -z);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        IPrecipitationManager precipitation = (IPrecipitationManager)world.getCapability(CapabilitiesAether.PRECIPITATION_MANAGER, null);
        Vector2f velocity = precipitation.getWindVector();
        for (int z2 = entityZ - radius; z2 <= entityZ + radius; ++z2) {
            for (int x2 = entityX - radius; x2 <= entityX + radius; ++x2) {
                float intensity;
                int index = (z2 - entityZ + 16) * 32 + x2 - entityX + 16;
                double rainX = (double)this.rainXCoords[index] * 0.5;
                double rainY = (double)this.rainYCoords[index] * 0.5;
                pos.func_181079_c(x2, 0, z2);
                float opacity = world.func_72867_j(partialTicks);
                if (!(opacity > 0.0f) || !world.func_72896_J()) continue;
                int height = world.func_175725_q((BlockPos)pos).func_177956_o();
                int yMin = entityY - radius;
                int yMax = entityY + radius;
                if (yMin < height) {
                    yMin = height;
                }
                if (yMax < height) {
                    yMax = height;
                }
                int y2 = height;
                if (height < l) {
                    y2 = l;
                }
                if (yMin == yMax) continue;
                this.random.setSeed(x2 * x2 * 3121 + x2 * 45238971 ^ z2 * z2 * 418711 + z2 * 13761);
                pos.func_181079_c(x2, yMin, z2);
                Biome biome = world.func_180494_b((BlockPos)pos);
                if (biome.func_150559_j()) {
                    float f = precipitation.getStrength() == PrecipitationStrength.STORM ? 2.5f : (intensity = precipitation.getStrength() == PrecipitationStrength.HEAVY ? 1.4f : 0.6f);
                    if (continuous != 1) {
                        if (continuous >= 0) {
                            tessellator.func_78381_a();
                        }
                        continuous = 1;
                        String textureKey = AetherCore.getResourcePath("textures/environment/weather/snow_" + precipitation.getStrength().getResourceId() + ".png");
                        ResourceLocation texture = this.textureCache.computeIfAbsent(textureKey, key -> new ResourceLocation(textureKey));
                        mc.func_110434_K().func_110577_a(texture);
                        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    float ticks = ((float)this.renderTicks + partialTicks) * intensity;
                    double d8 = (double)(-((float)this.renderTicks + partialTicks)) * 0.001 * (double)intensity;
                    double uOffset = this.random.nextDouble() + -((double)(ticks + partialTicks) * this.random.nextGaussian() * 0.01);
                    double vOffset = this.random.nextDouble() + -((double)(ticks + partialTicks) * this.random.nextGaussian() * 0.001);
                    double d11 = (double)((float)x2 + 0.5f) - entity.field_70165_t;
                    double d12 = (double)((float)z2 + 0.5f) - entity.field_70161_v;
                    float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)radius;
                    float alpha = ((1.0f - f6 * f6) * 0.3f + 0.5f) * opacity;
                    pos.func_181079_c(x2, y2, z2);
                    int light = (world.func_175626_b((BlockPos)pos, 0) * 3 + 0xF000F0) / 4;
                    int lightU = light >> 16 & 0xFFFF;
                    int lightV = light & 0xFFFF;
                    buffer.func_181662_b((double)x2 - rainX + 0.5, (double)yMax, (double)z2 - rainY + 0.5).func_187315_a(0.0 + uOffset, (double)yMin * 0.25 + d8 + vOffset).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_187314_a(lightU, lightV).func_181675_d();
                    buffer.func_181662_b((double)x2 + rainX + 0.5, (double)yMax, (double)z2 + rainY + 0.5).func_187315_a(1.0 + uOffset, (double)yMin * 0.25 + d8 + vOffset).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_187314_a(lightU, lightV).func_181675_d();
                    buffer.func_181662_b((double)x2 + rainX + 0.5, (double)yMin, (double)z2 + rainY + 0.5).func_187315_a(1.0 + uOffset, (double)yMax * 0.25 + d8 + vOffset).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_187314_a(lightU, lightV).func_181675_d();
                    buffer.func_181662_b((double)x2 - rainX + 0.5, (double)yMin, (double)z2 - rainY + 0.5).func_187315_a(0.0 + uOffset, (double)yMax * 0.25 + d8 + vOffset).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_187314_a(lightU, lightV).func_181675_d();
                    continue;
                }
                float f = precipitation.getStrength() == PrecipitationStrength.STORM ? 48.0f : (intensity = precipitation.getStrength() == PrecipitationStrength.HEAVY ? 64.0f : 128.0f);
                if (continuous != 0) {
                    if (continuous >= 0) {
                        tessellator.func_78381_a();
                    }
                    continuous = 0;
                    String textureKey = AetherCore.getResourcePath("textures/environment/weather/rain_" + precipitation.getStrength().getResourceId() + ".png");
                    ResourceLocation texture = this.textureCache.computeIfAbsent(textureKey, key -> new ResourceLocation(textureKey));
                    mc.func_110434_K().func_110577_a(texture);
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                }
                double textureVOffset = -((double)(this.renderTicks + x2 * x2 * 3121 + x2 * 45238971 + z2 * z2 * 418711 + z2 * 13761 & 0x1F) + (double)partialTicks) / (double)intensity * (3.0 + this.random.nextDouble());
                double d6 = (double)((float)x2 + 0.5f) - entity.field_70165_t;
                double d7 = (double)((float)z2 + 0.5f) - entity.field_70161_v;
                float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)radius;
                float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * opacity;
                pos.func_181079_c(x2, y2, z2);
                int light = world.func_175626_b((BlockPos)pos, 0);
                int lightU = light >> 16 & 0xFFFF;
                int lightV = light & 0xFFFF;
                int color = biome.func_185361_o();
                float red = (float)((color & 0xFF0000) >> 16) / 255.0f;
                float blue = (float)((color & 0xFF00) >> 8) / 255.0f;
                float green = (float)(color & 0xFF) / 255.0f;
                buffer.func_181662_b((double)x2 - rainX + 0.5, (double)yMax, (double)z2 - rainY + 0.5).func_187315_a(0.0, (double)yMin * 0.25 + textureVOffset).func_181666_a(red, blue, green, f4).func_187314_a(lightU, lightV).func_181675_d();
                buffer.func_181662_b((double)x2 + rainX + 0.5, (double)yMax, (double)z2 + rainY + 0.5).func_187315_a(1.0, (double)yMin * 0.25 + textureVOffset).func_181666_a(red, blue, green, f4).func_187314_a(lightU, lightV).func_181675_d();
                buffer.func_181662_b((double)x2 + rainX + 0.5 + (double)velocity.x, (double)yMin, (double)z2 + rainY + 0.5 + (double)velocity.y).func_187315_a(1.0, (double)yMax * 0.25 + textureVOffset).func_181666_a(red, blue, green, f4).func_187314_a(lightU, lightV).func_181675_d();
                buffer.func_181662_b((double)x2 - rainX + 0.5 + (double)velocity.x, (double)yMin, (double)z2 - rainY + 0.5 + (double)velocity.y).func_187315_a(0.0, (double)yMax * 0.25 + textureVOffset).func_181666_a(red, blue, green, f4).func_187314_a(lightU, lightV).func_181675_d();
            }
        }
        if (continuous >= 0) {
            tessellator.func_78381_a();
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        mc.field_71460_t.func_175072_h();
    }

    private void playSounds(Minecraft mc) {
        int z;
        int y;
        int x;
        if (mc.func_147113_T()) {
            return;
        }
        BlockPos pos = mc.field_71439_g.func_180425_c();
        IPrecipitationManager precipitation = (IPrecipitationManager)mc.field_71439_g.field_70170_p.getCapability(CapabilitiesAether.PRECIPITATION_MANAGER, null);
        if (!mc.field_71441_e.func_72896_J() || mc.field_71441_e.func_72867_j(mc.func_184121_ak()) <= 0.3f) {
            return;
        }
        int radius = 25;
        int frequency = 15;
        BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
        if (this.renderTicksSinceSound >= frequency && mc.field_71441_e.func_175642_b(EnumSkyBlock.SKY, new BlockPos(x = pos.func_177958_n() + mc.field_71441_e.field_73012_v.nextInt(radius) - radius / 2 + (int)(mc.field_71439_g.field_70159_w * (double)radius / 2.0), y = mc.field_71441_e.func_175672_r(new BlockPos(x, 255, z = pos.func_177952_p() + mc.field_71441_e.field_73012_v.nextInt(radius) - radius / 2 + (int)(mc.field_71439_g.field_70179_y * (double)radius / 2.0))).func_177956_o() + 1, z)) >= 15) {
            SoundEvent event = null;
            float volume = 1.0f;
            searchPos.func_181079_c(x, y, z);
            if (mc.field_71441_e.func_180494_b((BlockPos)searchPos).func_150559_j()) {
                if (precipitation.getStrength() == PrecipitationStrength.STORM) {
                    event = SoundsAether.environment_snow_wind;
                    volume = 0.6f;
                }
            } else if (precipitation.getStrength() == PrecipitationStrength.LIGHT) {
                event = SoundsAether.environment_rain_light;
                volume = 0.6f;
            } else {
                event = SoundsAether.environment_rain_heavy;
                volume = 0.7f;
            }
            this.renderTicksSinceSound = 0;
            if (event != null) {
                mc.field_71441_e.func_184134_a((double)x, (double)y, (double)z, event, SoundCategory.WEATHER, volume, 1.0f + mc.field_71441_e.field_73012_v.nextFloat() * 0.1f, true);
            }
        }
    }
}

