/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer.tiles;

import com.gildedgames.aether.client.models.entities.tile.ModelMoaEgg;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.entities.genes.moa.MoaGenePool;
import com.gildedgames.aether.common.entities.tiles.TileEntityMoaEgg;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityMoaEggRenderer
extends TileEntitySpecialRenderer<TileEntityMoaEgg> {
    private static final ResourceLocation TEXTURE_BASE = AetherCore.getResource("textures/tile_entities/moa_egg/base.png");
    private static final ResourceLocation TEXTURE_BEAK = AetherCore.getResource("textures/tile_entities/moa_egg/beak.png");
    private static final ResourceLocation TEXTURE_EYES = AetherCore.getResource("textures/tile_entities/moa_egg/head/eyes.png");
    public final ModelMoaEgg model = new ModelMoaEgg();

    public void render(TileEntityMoaEgg egg, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        MoaGenePool genePool = egg.getGenePool();
        if (genePool == null || genePool.getFeathers() == null) {
            return;
        }
        ResourceLocation BACK_MARKING = genePool.getMarks().gene().getEggBack();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.renderColor(genePool.getFeathers().gene().data().getRGB());
        this.func_147499_a(TEXTURE_BASE);
        this.model.renderAll(0.0625f);
        this.renderColor(genePool.getKeratin().gene().data().getRGB());
        this.func_147499_a(TEXTURE_BEAK);
        this.model.renderAll(0.0625f);
        this.renderColor(genePool.getFeathers().gene().data().darker().getRGB());
        this.func_147499_a(BACK_MARKING);
        this.model.renderAll(0.0625f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.renderColor(genePool.getEyes().gene().data().getRGB());
        this.func_147499_a(TEXTURE_EYES);
        this.model.renderAll(0.0625f);
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderColor(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor3f((float)red, (float)green, (float)blue);
    }
}

