/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer.tiles;

import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.client.models.entities.tile.ModelAltar;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.entities.tiles.TileEntityAltar;
import com.gildedgames.aether.common.items.armor.ItemAetherShield;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TileEntityAltarRenderer
extends TileEntitySpecialRenderer<TileEntityAltar> {
    private final ModelAltar model = new ModelAltar();
    private final ResourceLocation texture = AetherCore.getResource("textures/tile_entities/altar.png");
    private final double radius = 0.4;
    private final double theta = 5.0;

    public void render(TileEntityAltar altar, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        if (altar != null) {
            switch (altar.getFacing()) {
                case NORTH: {
                    GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
        }
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(this.texture);
        }
        this.model.render(0.0625f);
        if (altar != null) {
            ItemStack stack = altar.getStackOnAltar();
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.32f, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_147499_a(TextureMap.field_110575_b);
            if (stack != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179123_a();
                if (stack.func_77973_b() instanceof ItemBlock) {
                    GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.05f, (float)0.0f);
                } else if (stack.func_77973_b() instanceof ItemAetherShield) {
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.45f, (float)0.0f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)90.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)90.0f);
                } else {
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.13f, (float)0.0f);
                    GlStateManager.func_179114_b((float)90.0f, (float)90.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)90.0f);
                }
                this.renderItem(stack);
                GlStateManager.func_179099_b();
                GlStateManager.func_179121_F();
            }
            this.renderOrbitingItems(altar.getAmbrosiumCount(), altar.prevAnimationTicks + (altar.animationTicks - altar.prevAnimationTicks) * (double)partialTicks);
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    private void renderItem(ItemStack stack) {
        GlStateManager.func_179094_E();
        RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
        if (stack != null) {
            if (!itemRenderer.func_175050_a(stack)) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            IBakedModel model = itemRenderer.func_175037_a().func_178089_a(stack);
            itemRenderer.func_180454_a(stack, model);
        }
        GlStateManager.func_179121_F();
    }

    private void renderOrbitingItems(int amount, double ticks) {
        for (int i = 0; i < amount; ++i) {
            GlStateManager.func_179094_E();
            double alpha = ticks / (12.0 * (10.0 / (double)amount));
            double dist = Math.PI * (double)i / (double)amount * 2.0;
            double x = this.radius * Math.cos(this.theta + dist);
            double z = this.radius * Math.sin(this.theta + dist);
            double deltaX = z * Math.cos(alpha) - x * Math.sin(alpha);
            double deltaZ = x * Math.cos(alpha) + z * Math.sin(alpha);
            GlStateManager.func_179137_b((double)deltaX, (double)0.0, (double)deltaZ);
            GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)-90.0f, (float)0.0f);
            this.renderItem(new ItemStack(ItemsAether.ambrosium_shard));
            GlStateManager.func_179121_F();
        }
    }
}

