/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer.particles;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.world.islands.precipitation.IPrecipitationManager;
import com.gildedgames.aether.common.AetherCore;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ParticleLeaf
extends Particle {
    private final ResourceLocation sprite = AetherCore.getResource("textures/particles/skyroot_leaf_particle.png");
    private final float mulRotX;
    private final float mulRotY;
    private float prevRotX;
    private float prevRotY;
    private float rotX;
    private float rotY;

    public ParticleLeaf(World worldIn, double posXIn, double posYIn, double posZIn, double motionX, double motionY, double motionZ, Block block) {
        super(worldIn, posXIn, posYIn, posZIn);
        IPrecipitationManager precipitation;
        if (block == BlocksAether.green_skyroot_leaves) {
            this.field_70552_h = 0.627f;
            this.field_70553_i = 0.753f;
            this.field_70551_j = 0.522f;
        } else if (block == BlocksAether.highlands_bush) {
            this.field_70552_h = 0.466f;
            this.field_70553_i = 0.619f;
            this.field_70551_j = 0.388f;
        } else if (block == BlocksAether.amberoot_leaves) {
            this.field_70552_h = 0.976f;
            this.field_70553_i = 0.745f;
            this.field_70551_j = 0.0f;
        } else if (block == BlocksAether.blue_dark_skyroot_leaves) {
            this.field_70552_h = 0.282f;
            this.field_70553_i = 0.401f;
            this.field_70551_j = 0.428f;
        } else if (block == BlocksAether.blue_light_skyroot_leaves) {
            this.field_70552_h = 0.592f;
            this.field_70553_i = 0.72f;
            this.field_70551_j = 0.733f;
        } else if (block == BlocksAether.blue_skyroot_leaves) {
            this.field_70552_h = 0.458f;
            this.field_70553_i = 0.606f;
            this.field_70551_j = 0.657f;
        } else if (block == BlocksAether.dark_blue_dark_skyroot_leaves) {
            this.field_70552_h = 0.294f;
            this.field_70553_i = 0.355f;
            this.field_70551_j = 0.588f;
        } else if (block == BlocksAether.dark_blue_light_skyroot_leaves) {
            this.field_70552_h = 0.468f;
            this.field_70553_i = 0.501f;
            this.field_70551_j = 0.734f;
        } else if (block == BlocksAether.dark_blue_skyroot_leaves) {
            this.field_70552_h = 0.355f;
            this.field_70553_i = 0.41f;
            this.field_70551_j = 0.725f;
        } else if (block == BlocksAether.green_dark_skyroot_leaves) {
            this.field_70552_h = 0.326f;
            this.field_70553_i = 0.428f;
            this.field_70551_j = 0.228f;
        } else if (block == BlocksAether.green_light_skyroot_leaves) {
            this.field_70552_h = 0.697f;
            this.field_70553_i = 0.811f;
            this.field_70551_j = 0.597f;
        } else if (block == BlocksAether.therawood_leaves) {
            this.field_70552_h = 0.253f;
            this.field_70553_i = 0.512f;
            this.field_70551_j = 0.301f;
        } else if (block == BlocksAether.mutant_leaves || block == BlocksAether.mutant_leaves_decorated) {
            this.field_70552_h = 0.569f;
            this.field_70553_i = 0.533f;
            this.field_70551_j = 0.706f;
        }
        this.field_187130_j = motionY;
        this.field_187129_i = motionX;
        this.field_187131_k = motionZ;
        if (worldIn.func_72896_J() && (precipitation = (IPrecipitationManager)worldIn.getCapability(CapabilitiesAether.PRECIPITATION_MANAGER, null)) != null) {
            float strength = precipitation.getStrength().getWindForceMultiplier();
            this.field_187129_i += (double)(precipitation.getWindVector().x * strength);
            this.field_187131_k += (double)(precipitation.getWindVector().y * strength);
            this.field_187130_j += (double)(-strength * 0.5f);
        }
        this.mulRotY = this.field_187136_p.nextFloat() * 100.0f * (float)this.field_187130_j;
        this.mulRotX = this.field_187136_p.nextFloat() * 100.0f * (float)this.field_187130_j;
        this.field_70547_e = 100;
        this.field_190017_n = false;
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.prevRotX = this.rotX;
        this.prevRotY = this.rotY;
        this.rotX += this.mulRotX;
        this.rotY += this.mulRotY;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.sprite);
        GlStateManager.func_179140_f();
        double x = this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an;
        double y = this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao;
        double z = this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap;
        int brightness = this.func_189214_a(partialTicks);
        int j = brightness >> 16 & 0xFFFF;
        int k = brightness & 0xFFFF;
        float scale = 0.1f * this.field_70544_f;
        float f2 = this.prevRotX + (this.rotX - this.prevRotX) * partialTicks;
        float f3 = this.prevRotY + (this.rotY - this.prevRotY) * partialTicks;
        int i = 0;
        rotationX = MathHelper.func_76134_b((float)(f3 * ((float)Math.PI / 180))) * (float)(1 - i * 2);
        rotationZ = MathHelper.func_76126_a((float)(f3 * ((float)Math.PI / 180))) * (float)(1 - i * 2);
        rotationYZ = -rotationZ * MathHelper.func_76126_a((float)(f2 * ((float)Math.PI / 180))) * (float)(1 - i * 2);
        rotationXY = rotationX * MathHelper.func_76126_a((float)(f2 * ((float)Math.PI / 180))) * (float)(1 - i * 2);
        rotationXZ = MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)));
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(-rotationYZ * scale - rotationXZ * scale)), new Vec3d((double)(-rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(-rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(rotationYZ * scale - rotationXZ * scale))};
        float a = 1.0f - Math.max(0.0f, (float)this.field_70546_d - 70.0f) * 0.03f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        buffer.func_181662_b(x + avec3d[0].field_72450_a, y + avec3d[0].field_72448_b, z + avec3d[0].field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, a).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(x + avec3d[1].field_72450_a, y + avec3d[1].field_72448_b, z + avec3d[1].field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, a).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(x + avec3d[2].field_72450_a, y + avec3d[2].field_72448_b, z + avec3d[2].field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, a).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(x + avec3d[3].field_72450_a, y + avec3d[3].field_72448_b, z + avec3d[3].field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, a).func_187314_a(j, k).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public int func_70537_b() {
        return 3;
    }
}

