/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer.entities.living;

import com.gildedgames.aether.client.models.entities.living.ModelSkyrootLizard;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.entities.animals.EntitySkyrootLizard;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class RenderSkyrootLizard
extends RenderLiving<EntitySkyrootLizard> {
    private static final ResourceLocation AMBERROOT = AetherCore.getResource("textures/entities/skyroot_lizard/skyroot_lizard_amberoot.png");
    private static final ResourceLocation GREATROOT = AetherCore.getResource("textures/entities/skyroot_lizard/skyroot_lizard_greatroot.png");
    private static final ResourceLocation SKYROOT = AetherCore.getResource("textures/entities/skyroot_lizard/skyroot_lizard_skyroot.png");
    private static final ResourceLocation WISPROOT = AetherCore.getResource("textures/entities/skyroot_lizard/skyroot_lizard_wisproot.png");
    private static final ResourceLocation LEAF_LAYER = AetherCore.getResource("textures/entities/skyroot_lizard/skyroot_lizard_leaf.png");

    public RenderSkyrootLizard(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelSkyrootLizard(), 0.4f);
    }

    public void renderLizard(EntitySkyrootLizard entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelSkyrootLizard model = (ModelSkyrootLizard)this.field_77045_g;
        switch (entity.getLeafType()) {
            case SKYROOT: {
                this.field_76990_c.field_78724_e.func_110577_a(SKYROOT);
                break;
            }
            case WISPROOT: {
                this.field_76990_c.field_78724_e.func_110577_a(WISPROOT);
                break;
            }
            case GREATROOT: {
                this.field_76990_c.field_78724_e.func_110577_a(GREATROOT);
                break;
            }
            case AMBERROOT: {
                this.field_76990_c.field_78724_e.func_110577_a(AMBERROOT);
                break;
            }
            default: {
                return;
            }
        }
        model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        int color = entity.getLizardAccentColor();
        if (color != Integer.MIN_VALUE) {
            this.field_76990_c.field_78724_e.func_110577_a(LEAF_LAYER);
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            GlStateManager.func_179131_c((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)1.0f);
        }
        model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    protected void renderModel(EntitySkyrootLizard entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        boolean playerInvisible;
        boolean globalInvisible = !entity.func_82150_aj() || this.field_188301_f;
        boolean bl = playerInvisible = !globalInvisible && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (globalInvisible || playerInvisible) {
            this.renderLizard(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    protected ResourceLocation getEntityTexture(EntitySkyrootLizard entity) {
        return null;
    }
}

