/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer.entities.living;

import com.gildedgames.aether.client.models.entities.living.ModelMoaBase;
import com.gildedgames.aether.client.models.entities.living.ModelMoaLodHigh;
import com.gildedgames.aether.client.models.entities.living.ModelMoaLodLow;
import com.gildedgames.aether.client.renderer.EyeUtil;
import com.gildedgames.aether.client.renderer.entities.living.RenderLivingLOD;
import com.gildedgames.aether.client.util.SpriteGeneric;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.entities.animals.EntityMoa;
import com.gildedgames.aether.common.entities.genes.AnimalGender;
import com.gildedgames.aether.common.entities.genes.moa.MoaGenePool;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderMoa
extends RenderLivingLOD<EntityMoa> {
    private static final ResourceLocation AECHOR_PETAL_TEXTURE = AetherCore.getResource("textures/items/consumables/aechor_petal.png");
    private static final SpriteGeneric SPRITE = new SpriteGeneric("aechor_petal.png", 16, 16);
    private static final ResourceLocation CURVED_BODY = AetherCore.getResource("textures/entities/moa/curved_main.png");
    private static final ResourceLocation CURVED_BODY_HIGHLIGHT = AetherCore.getResource("textures/entities/moa/curved_highlight.png");
    private static final ResourceLocation FLAT_BODY = AetherCore.getResource("textures/entities/moa/flat_main.png");
    private static final ResourceLocation FLAT_BODY_HIGHLIGHT = AetherCore.getResource("textures/entities/moa/flat_highlight.png");
    private static final ResourceLocation POINTED_BODY = AetherCore.getResource("textures/entities/moa/pointed_main.png");
    private static final ResourceLocation POINTED_BODY_HIGHLIGHT = AetherCore.getResource("textures/entities/moa/pointed_highlight.png");
    private static final ResourceLocation BEAK = AetherCore.getResource("textures/entities/moa/keratin.png");
    private static final ResourceLocation EYES = AetherCore.getResource("textures/entities/moa/eyes.png");
    private static final ResourceLocation TONGUE = AetherCore.getResource("textures/entities/moa/tongue.png");
    private static final ResourceLocation SADDLE = AetherCore.getResource("textures/entities/moa/saddle.png");
    private static final ResourceLocation EYES_CLOSED = AetherCore.getResource("textures/entities/moa/eyes_closed.png");
    private static final ResourceLocation PUPIL_LEFT = AetherCore.getResource("textures/entities/moa/pupil_left.png");
    private static final ResourceLocation PUPIL_RIGHT = AetherCore.getResource("textures/entities/moa/pupil_right.png");

    public RenderMoa(RenderManager manager) {
        super(manager, new ModelMoaLodHigh(), new ModelMoaLodLow(), 0.5f);
        SPRITE.func_110971_a(16, 16, 0, 0, false);
    }

    protected void preRenderCallback(EntityMoa entityliving, float partialTicks) {
        float moaScale = entityliving.func_70631_g_() ? 0.5f : 0.85f;
        GL11.glScalef((float)(moaScale += entityliving.isGroupLeader() ? 0.15f : 0.0f), (float)moaScale, (float)moaScale);
    }

    private void renderMoa(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        String mark;
        EntityMoa moa = (EntityMoa)entity;
        MoaGenePool genePool = (MoaGenePool)moa.getGenePool();
        if (genePool == null || genePool.getFeathers() == null) {
            return;
        }
        Color base = genePool.getFeathers().gene().data();
        float[] hsb = new float[3];
        Color.RGBtoHSB(base.getRed(), base.getGreen(), base.getBlue(), hsb);
        Color highlight = genePool.getFeathers().gene().data().brighter().brighter();
        GlStateManager.func_179124_c((float)((float)base.getRed() / 255.0f), (float)((float)base.getGreen() / 255.0f), (float)((float)base.getBlue() / 255.0f));
        ModelMoaBase model = (ModelMoaBase)this.field_77045_g;
        model.LegL2.field_78807_k = true;
        model.LegR2.field_78807_k = true;
        model.JawMain.field_78807_k = true;
        model.HeadBeakMain.field_78807_k = true;
        if (!this.isLowDetail) {
            Color eyesC = genePool.getEyes().gene().data();
            model.HeadMain.callback = () -> {
                GlStateManager.func_179124_c((float)((float)eyesC.getRed() / 255.0f), (float)((float)eyesC.getGreen() / 255.0f), (float)((float)eyesC.getBlue() / 255.0f));
                this.field_76990_c.field_78724_e.func_110577_a(EYES);
                model.HeadFront.render(scale, true, false);
                GlStateManager.func_179124_c((float)((float)base.getRed() / 255.0f), (float)((float)base.getGreen() / 255.0f), (float)((float)base.getBlue() / 255.0f));
                EyeUtil.renderEyesFast(model, model.HeadFront, model.HeadFront, entity, scale, PUPIL_LEFT, PUPIL_RIGHT, EYES_CLOSED, EYES, false);
                if (genePool.getMarks() != null) {
                    String mark = genePool.getMarks().gene().getResourceName();
                    if (mark.equals("curved")) {
                        this.field_76990_c.field_78724_e.func_110577_a(CURVED_BODY);
                    } else if (mark.equals("flat")) {
                        this.field_76990_c.field_78724_e.func_110577_a(FLAT_BODY);
                    } else {
                        this.field_76990_c.field_78724_e.func_110577_a(POINTED_BODY);
                    }
                }
            };
        }
        if (genePool.getMarks() != null) {
            mark = genePool.getMarks().gene().getResourceName();
            if (mark.equals("curved")) {
                this.field_76990_c.field_78724_e.func_110577_a(CURVED_BODY);
            } else if (mark.equals("flat")) {
                this.field_76990_c.field_78724_e.func_110577_a(FLAT_BODY);
            } else {
                this.field_76990_c.field_78724_e.func_110577_a(POINTED_BODY);
            }
        }
        model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        model.LegL2.field_78807_k = false;
        model.LegR2.field_78807_k = false;
        model.JawMain.field_78807_k = false;
        model.HeadBeakMain.field_78807_k = false;
        if (genePool.getMarks() != null) {
            mark = genePool.getMarks().gene().getResourceName();
            if (mark.equals("curved")) {
                this.field_76990_c.field_78724_e.func_110577_a(CURVED_BODY_HIGHLIGHT);
            } else if (mark.equals("flat")) {
                this.field_76990_c.field_78724_e.func_110577_a(FLAT_BODY_HIGHLIGHT);
            } else {
                this.field_76990_c.field_78724_e.func_110577_a(POINTED_BODY_HIGHLIGHT);
            }
        }
        GL11.glColor3f((float)((float)highlight.getRed() / 255.0f), (float)((float)highlight.getGreen() / 255.0f), (float)((float)highlight.getBlue() / 255.0f));
        model.setDefaultDisplayState(false);
        model.HeadFeatherL1.forceDisplayFlag = true;
        model.HeadFeatherL2.forceDisplayFlag = true;
        model.HeadFeatherR1.forceDisplayFlag = true;
        model.HeadFeatherR2.forceDisplayFlag = true;
        model.WingLFeatherInt1.forceDisplayFlag = true;
        model.WingLFeatherInt2.forceDisplayFlag = true;
        model.WingLFeatherExt1.forceDisplayFlag = true;
        model.WingLFeatherExt2.forceDisplayFlag = true;
        model.WingLFeatherExt3.forceDisplayFlag = true;
        model.WingRFeatherInt1.forceDisplayFlag = true;
        model.WingRFeatherInt2.forceDisplayFlag = true;
        model.WingRFeatherExt1.forceDisplayFlag = true;
        model.WingRFeatherExt2.forceDisplayFlag = true;
        model.WingRFeatherExt3.forceDisplayFlag = true;
        if (!this.isLowDetail) {
            model.LegLTalonL.forceDisplayFlag = true;
            model.LegLTalonR.forceDisplayFlag = true;
            model.LegLTalonM.forceDisplayFlag = true;
            model.LegRTalonL.forceDisplayFlag = true;
            model.LegRTalonR.forceDisplayFlag = true;
            model.LegRTalonM.forceDisplayFlag = true;
        }
        model.TailFeatherL.forceDisplayFlag = true;
        model.TailFeatherR.forceDisplayFlag = true;
        model.TailFeatherM.forceDisplayFlag = true;
        model.BodyMain.forceDisplayFlag = true;
        model.BodyFront.forceDisplayFlag = true;
        model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        model.setDefaultDisplayState(true);
        Color beakColor = genePool.getKeratin().gene().data();
        GlStateManager.func_179124_c((float)((float)beakColor.getRed() / 255.0f), (float)((float)beakColor.getGreen() / 255.0f), (float)((float)beakColor.getBlue() / 255.0f));
        this.field_76990_c.field_78724_e.func_110577_a(BEAK);
        model.setDefaultDisplayState(false);
        model.HeadBrow.forceDisplayFlag = true;
        model.JawMain.forceDisplayFlag = true;
        if (!this.isLowDetail) {
            model.JawFrontL.forceDisplayFlag = true;
            model.JawFrontR.forceDisplayFlag = true;
            model.JawBack.forceDisplayFlag = true;
            model.JawToothL1.forceDisplayFlag = true;
            model.JawToothL2.forceDisplayFlag = true;
            model.JawToothL3.forceDisplayFlag = true;
            model.JawToothL1_1.forceDisplayFlag = true;
            model.JawToothR2.forceDisplayFlag = true;
            model.JawToothR3.forceDisplayFlag = true;
            model.HeadBeakFrontL.forceDisplayFlag = true;
            model.HeadBeakFrontR.forceDisplayFlag = true;
        }
        model.HeadBeakMain.forceDisplayFlag = true;
        model.LegL2.forceDisplayFlag = true;
        model.LegL3.forceDisplayFlag = true;
        model.LegLAnkle.forceDisplayFlag = true;
        model.LegLFoot.forceDisplayFlag = true;
        model.LegLToeL.forceDisplayFlag = true;
        model.LegLToeM.forceDisplayFlag = true;
        model.LegLToeR.forceDisplayFlag = true;
        model.LegR2.forceDisplayFlag = true;
        model.LegR3.forceDisplayFlag = true;
        model.LegRAnkle.forceDisplayFlag = true;
        model.LegRFoot.forceDisplayFlag = true;
        model.LegRToeL.forceDisplayFlag = true;
        model.LegRToeM.forceDisplayFlag = true;
        model.LegRToeR.forceDisplayFlag = true;
        model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        model.setDefaultDisplayState(true);
        if (moa.isSaddled()) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.001f, (float)0.0f);
            GL11.glScalef((float)1.01f, (float)1.01f, (float)1.01f);
            this.field_76990_c.field_78724_e.func_110577_a(SADDLE);
            model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    protected void renderModel(EntityMoa entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        boolean playerInvisible;
        boolean globalInvisible = !entity.func_82150_aj() || this.field_188301_f;
        boolean bl = playerInvisible = !globalInvisible && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (globalInvisible || playerInvisible) {
            this.renderMoa((EntityLivingBase)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public void doRender(EntityMoa entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.isHungry()) {
            this.func_147906_a((Entity)entity, "Hungry", x, y + 0.15 + (entity.getGender() == AnimalGender.MALE ? 0.0 : -0.35), z, 64);
            this.drawAechorPetal(x, y + (double)entity.field_70131_O + 0.8 + (entity.getGender() == AnimalGender.MALE ? 0.0 : -0.35), z, 0.5);
        }
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityMoa entity) {
        return null;
    }

    private void drawAechorPetal(double x, double y, double z, double scale) {
        GL11.glPushMatrix();
        Tessellator tesselator = Tessellator.func_178181_a();
        GL11.glEnable((int)3553);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        this.func_110776_a(AECHOR_PETAL_TEXTURE);
        this.renderEntity(tesselator.func_178180_c(), SPRITE);
        tesselator.func_78381_a();
        GL11.glPopMatrix();
    }

    private void renderEntity(BufferBuilder renderer, TextureAtlasSprite icon) {
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        GL11.glRotatef((float)(180.0f + Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)-1.0f, (float)0.0f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        renderer.func_181662_b(-0.5, -0.25, 0.0).func_187315_a((double)f, (double)f3).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        renderer.func_181662_b(0.5, -0.25, 0.0).func_187315_a((double)f1, (double)f3).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        renderer.func_181662_b(0.5, 0.75, 0.0).func_187315_a((double)f1, (double)f2).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        renderer.func_181662_b(-0.5, 0.75, 0.0).func_187315_a((double)f, (double)f2).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

