/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer.entities.living;

import com.gildedgames.aether.client.models.entities.living.ModelCarrionSproutLodHigh;
import com.gildedgames.aether.client.models.entities.living.ModelCarrionSproutLodLow;
import com.gildedgames.aether.client.renderer.entities.living.RenderLivingLOD;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.entities.animals.EntityCarrionSprout;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderCarrionSprout
extends RenderLivingLOD<EntityCarrionSprout> {
    private static final ResourceLocation TEXTURE = AetherCore.getResource("textures/entities/carrion_sprout/carrion_sprout.png");
    private final ModelCarrionSproutLodHigh plantModel;

    public RenderCarrionSprout(RenderManager manager) {
        super(manager, new ModelCarrionSproutLodHigh(), new ModelCarrionSproutLodLow(), 0.75f);
        this.plantModel = (ModelCarrionSproutLodHigh)this.field_77045_g;
    }

    protected void preRenderCallback(EntityCarrionSprout sprout, float partialTicks) {
        float f2;
        float scale = 0.5f + (float)sprout.getSproutSize() * 0.1f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        float sinage = sprout.prevSinage + (sprout.sinage - sprout.prevSinage) * partialTicks;
        float f1 = (float)Math.sin(sinage - 1.0f);
        if (sprout.field_70737_aN > 0) {
            f1 *= 0.45f;
            f1 -= 0.125f;
            f2 = 1.75f + (float)Math.sin(sinage + 2.0f) * 1.5f;
        } else {
            f1 *= 0.25f;
            f2 = 1.75f + (float)Math.sin(sinage + 2.0f) * 1.5f;
        }
        this.plantModel.sinage = f1;
        this.plantModel.sinage2 = f2;
        this.field_76989_e = 0.1f * (float)sprout.getSproutSize();
    }

    protected ResourceLocation getEntityTexture(EntityCarrionSprout entity) {
        return TEXTURE;
    }

    @Override
    protected double getHighLODMinDistanceSq() {
        return 64.0;
    }
}

