/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer.entities.companions;

import com.gildedgames.aether.common.entities.companions.EntityCompanion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public abstract class RenderCompanion<T extends EntityCompanion>
extends RenderLiving<T> {
    public static final boolean RENDER_FADE_ON_NEAR = true;
    private final double distanceLimit;

    public RenderCompanion(RenderManager renderManager, ModelBase model, float shadowSize, double distanceLimit) {
        super(renderManager, model, shadowSize);
        this.distanceLimit = distanceLimit;
    }

    protected void renderModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean isInvisible;
        boolean renderOutlines = !entity.func_82150_aj() || this.field_188301_f;
        boolean bl = isInvisible = !renderOutlines && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (renderOutlines || isInvisible) {
            if (!this.func_180548_c((Entity)entity)) {
                return;
            }
            if (isInvisible) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            EntityPlayer owner = ((EntityCompanion)((Object)entity)).getOwner();
            float opacity = 1.0f;
            if (owner != null) {
                double distance = entity.func_70068_e((Entity)owner);
                opacity = (float)Math.min((double)0.1f + 1.0 * (distance / this.distanceLimit), 1.0);
            }
            if (opacity < 1.0f) {
                GL11.glPushMatrix();
                GlStateManager.func_179147_l();
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            }
            this.field_77045_g.func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            this.renderExtra(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, opacity);
            if (opacity < 1.0f) {
                GlStateManager.func_179084_k();
                GL11.glPopMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (isInvisible) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    protected void renderExtra(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, float opacity) {
    }
}

