/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer;

import com.gildedgames.aether.api.items.equipment.ItemEquipmentSlot;
import com.gildedgames.aether.api.patron.IPatronRewardRenderer;
import com.gildedgames.aether.api.player.inventory.IInventoryEquipment;
import com.gildedgames.aether.client.models.entities.player.LayerAetherPatronArmor;
import com.gildedgames.aether.client.models.entities.player.LayerAetherPlayerGloves;
import com.gildedgames.aether.client.models.entities.player.LayerArmorProxy;
import com.gildedgames.aether.client.models.entities.player.LayerHeadShadow;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerEquipmentModule;
import com.gildedgames.aether.common.patron.armor.PatronRewardArmor;
import com.gildedgames.aether.common.util.helpers.EntityUtil;
import com.gildedgames.orbis.lib.util.InputHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class PatronRewardArmorRenderer
implements IPatronRewardRenderer {
    private final PatronRewardArmor reward;
    private AbstractClientPlayer player;
    private PlayerAether playerAether;
    private RenderPlayer renderPlayer;
    private LayerAetherPatronArmor armorPreviewLayer;
    private LayerAetherPlayerGloves glovePreviewLayer;
    private LayerHeadShadow shadowPreviewLayer;
    private LayerArmorProxy vanillaArmorPreviewLayer;

    public PatronRewardArmorRenderer(PatronRewardArmor reward) {
        this.reward = reward;
    }

    private ItemStack getGloves() {
        IInventoryEquipment inventory = this.playerAether.getModule(PlayerEquipmentModule.class).getInventory();
        int slot = inventory.getNextEmptySlotForType(ItemEquipmentSlot.HANDWEAR);
        if (slot >= 0) {
            return inventory.func_70301_a(slot);
        }
        return ItemStack.field_190927_a;
    }

    private void setGloves(ItemStack stack) {
        IInventoryEquipment inventory = this.playerAether.getModule(PlayerEquipmentModule.class).getInventory();
        inventory.func_70299_a(2, stack);
    }

    @Override
    public void renderInit() {
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.playerAether = PlayerAether.getPlayer((EntityPlayer)this.player);
        this.renderPlayer = new RenderPlayer(Minecraft.func_71410_x().func_175598_ae(), EntityUtil.getSkin((EntityPlayer)this.player).equals("slim"));
        ArrayList original = new ArrayList(this.renderPlayer.field_177097_h);
        ArrayList<Object> updated = new ArrayList<Object>();
        for (LayerRenderer i : original) {
            if (i instanceof LayerBipedArmor) {
                this.vanillaArmorPreviewLayer = new LayerArmorProxy((RenderLivingBase<?>)this.renderPlayer, (LayerBipedArmor)i);
                updated.add((Object)this.vanillaArmorPreviewLayer);
                continue;
            }
            updated.add(i);
        }
        this.armorPreviewLayer = new LayerAetherPatronArmor((RenderLivingBase<?>)this.renderPlayer);
        updated.add(this.armorPreviewLayer);
        this.glovePreviewLayer = new LayerAetherPlayerGloves((RenderLivingBase<?>)this.renderPlayer);
        updated.add((Object)this.glovePreviewLayer);
        this.shadowPreviewLayer = new LayerHeadShadow((RenderLivingBase<?>)this.renderPlayer);
        updated.add((Object)this.shadowPreviewLayer);
        original.clear();
        original.addAll(updated);
    }

    @Override
    public void renderPreview(int posX, int posY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179142_g();
        double mouseX = posX - InputHelper.getMouseX();
        double mouseY = posY - InputHelper.getMouseY() - 42;
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179139_a((double)4.0, (double)4.0, (double)4.0);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = this.player.field_70761_aq;
        float f1 = this.player.field_70177_z;
        float f2 = this.player.field_70125_A;
        float f3 = this.player.field_70758_at;
        float f4 = this.player.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.player.field_70761_aq = (float)Math.atan(mouseX / 40.0) * 20.0f;
        this.player.field_70177_z = (float)Math.atan(mouseX / 40.0) * 40.0f;
        this.player.field_70125_A = -((float)Math.atan(mouseY / 40.0)) * 20.0f;
        this.player.field_70759_as = this.player.field_70177_z;
        this.player.field_70758_at = this.player.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)-10.0, (double)10.0, (double)10.0);
        this.armorPreviewLayer.setPreviewArmor(this.reward);
        this.glovePreviewLayer.setPreviewArmor(this.reward);
        this.shadowPreviewLayer.setPreviewArmor(this.reward);
        this.vanillaArmorPreviewLayer.setPreviewArmor(this.reward);
        this.renderPlayer.func_76986_a(this.player, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        this.player.field_70761_aq = f;
        this.player.field_70177_z = f1;
        this.player.field_70125_A = f2;
        this.player.field_70758_at = f3;
        this.player.field_70759_as = f4;
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179121_F();
    }

    public void setItemStackToSlot(EntityEquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            this.player.field_71071_by.field_70462_a.set(this.player.field_71071_by.field_70461_c, (Object)stack);
        } else if (slotIn == EntityEquipmentSlot.OFFHAND) {
            this.player.field_71071_by.field_184439_c.set(0, (Object)stack);
        } else if (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
            this.player.field_71071_by.field_70460_b.set(slotIn.func_188454_b(), (Object)stack);
        }
    }
}

